
/****************************************************************
daSniff - simple open source customizable sniffer for windows

Known problems:
1. Requires Windows 2000 or newer and administrator privileges
2. Does not catch outgoing traffic from the computer it is running on!

The sniffing code is based on code of Natas (http://intex.ath.cx)

Modifications of any kind are permitted ;)
Sending new code and ideas to stjordanov@hotmail.com will be appreciated

Author: Demosten - http://demosten.com (stjordanov@hotmail.com)

****************************************************************/

#include <stdio.h>
#include <winsock2.h>
#include "daSniff.h"
#include "NetAdapterA.h"

#define MAX_ADAPTERS	(20)

typedef struct _MY_SOCKET_ADDRESS_LIST {
    INT iAddressCount;
    SOCKET_ADDRESS Address[MAX_ADAPTERS];
} MY_SOCKET_ADDRESS_LIST;

/****************************************************************
get ip address of adapter #num in ifx
****************************************************************/
int GetAdapter(SOCKET s, SOCKADDR_IN *ifx, int num)
{
MY_SOCKET_ADDRESS_LIST slist;
DWORD dwBytesRet;

    if (SOCKET_ERROR == WSAIoctl(s, SIO_ADDRESS_LIST_QUERY,
		NULL, 0, &slist, sizeof(MY_SOCKET_ADDRESS_LIST), &dwBytesRet, NULL, NULL)) {
		sprintf(szErrorString, "WSAIoctl(SIO_ADDRESS_LIST_QUERY) failed - error code: %u\n",
			WSAGetLastError());
		AddToMessageLog(szErrorString, EVENTLOG_ERROR_TYPE);
        return 1;
    }
    if (num >= slist.iAddressCount)
		return 2;
    ifx->sin_addr.s_addr = ((SOCKADDR_IN *)slist.Address[num].lpSockaddr)->sin_addr.s_addr;
	return 0;
}
/****************************************************************
get the list of all available adapters
return 0 on success
****************************************************************/
int GetAdapterList(MY_SOCKET_ADDRESS_LIST *slist)
{
SOCKET sock;
DWORD dwBytesRet;
int ret;

    sock = socket(AF_INET, SOCK_STREAM, IPPROTO_IP);
    if (SOCKET_ERROR == sock) {
		sprintf(szErrorString, "socket(AF_INET, SOCK_STREAM, IPPROTO_IP) failed - error code: %u\n",
			WSAGetLastError());
		AddToMessageLog(szErrorString, EVENTLOG_ERROR_TYPE);
		return 1;
	}
    ret = WSAIoctl(sock, SIO_ADDRESS_LIST_QUERY, NULL, 0, slist, sizeof(MY_SOCKET_ADDRESS_LIST), &dwBytesRet, NULL, NULL);
    if (SOCKET_ERROR == ret) {
		sprintf(szErrorString, "WSAIoctl(sock, SIO_ADDRESS_LIST_QUERY ...) failed - error code: %u\n",
			WSAGetLastError());
		AddToMessageLog(szErrorString, EVENTLOG_ERROR_TYPE);
		return 2;
	}
	closesocket(sock);
    return 0;
}
/****************************************************************
list all available net adapters by address
****************************************************************/
int ListAdapters(void)
{
MY_SOCKET_ADDRESS_LIST slist;
int iCounter;

	if (0 == GetAdapterList(&slist)) {
		fprintf(stdout, "Found %u adapters:\n\n", slist.iAddressCount);
		for (iCounter = 0; iCounter <= (slist.iAddressCount-1); iCounter++) {
			/* bugfix for error with more than one network adapter on some machines -> sprintf(buf,"#%d -> ",i); */
			fprintf(stdout,"#%d  ->  %s\n", iCounter,
				inet_ntoa(((SOCKADDR_IN *)slist.Address[iCounter].lpSockaddr)->sin_addr));
		}
		return slist.iAddressCount;
	}
	return 0;
}
