
/****************************************************************
daSniff - simple open source customizable sniffer for windows

Known problems: 
1. Requires Windows 2000 or newer and administrator privileges
2. Does not catch outgoing traffic from the computer it is running on!

The sniffing code is based on code of Natas (http://intex.ath.cx)

Modifications of any kind are permitted ;)
Sending new code and ideas to stjordanov@hotmail.com will be appreciated

Author: Demosten - http://demosten.com (stjordanov@hotmail.com)

****************************************************************/

#include <stdio.h>
#include <winsock2.h>
#include "daSniff.h"
#include "PacketCaptureA.h"
#include "NetAdapterA.h"
#include "ParseFile.h"
#include "Filter.h"

static SOCKET sock;					/* the socket handle */
static BOOL bThreadActive = TRUE;	/* is the thread active? */
static HANDLE hSniffThread;			/* sniff-thread handle */
static DWORD dwSniffThreadID;		/* sniff-thread id */

/****************************************************************
create sniffing socket and bind it to the adapter iAdapterNr
****************************************************************/
int InitializeCapture(int iAdapterNr)
{
SOCKADDR_IN   if0;
unsigned int  optval;
DWORD         dwBytesRet;

    sock = WSASocket(AF_INET, SOCK_RAW, IPPROTO_IP, NULL, 0, WSA_FLAG_OVERLAPPED);
    if (INVALID_SOCKET == sock) {
		sprintf(szErrorString, "Creation of Socket(SOCK_RAW/IPPROTO_IP) failed: %u\n", WSAGetLastError());
		AddToMessageLog(szErrorString, EVENTLOG_ERROR_TYPE);
        return 1;
    }
	
	if (0 != GetAdapter(sock, &if0, iAdapterNr)) {
        sprintf(szErrorString, "Unable to obtain selected network adapter!\n");
		AddToMessageLog(szErrorString, EVENTLOG_ERROR_TYPE);
        return 2;
    }

    if0.sin_family = AF_INET;
    if0.sin_port = htons(0);
    if (SOCKET_ERROR == bind(sock, (SOCKADDR *)&if0, sizeof(if0))) {
        sprintf(szErrorString, "Bind call failed: %u\n", WSAGetLastError());
		AddToMessageLog(szErrorString, EVENTLOG_ERROR_TYPE);
        return 3;
    }

    optval=1;   
    if (SOCKET_ERROR == WSAIoctl(sock, SIO_RCVALL, &optval, sizeof(optval), 
							NULL, 0, &dwBytesRet, NULL, NULL)) {
		sprintf(szErrorString, "WSAIoCtl(SIO_RCVALL) failed: %u\n", WSAGetLastError());
		AddToMessageLog(szErrorString, EVENTLOG_ERROR_TYPE);
		return 4;
	}
    
	return 0;
}
/****************************************************************
read packet (actual sniffing)
****************************************************************/
int GetPacket(WSABUF *wbuf)
{
DWORD dwBytesRet = 0, dwFlags = 0;

    if (SOCKET_ERROR == WSARecv(sock, wbuf, 1, &dwBytesRet, &dwFlags, NULL, NULL))
		fprintf(stderr,"WSARecv failed. Code %u\n",WSAGetLastError());
	wbuf->len=dwBytesRet;
   
	return 0;
}
/****************************************************************
stop sniffing thread and close sniffing socket
****************************************************************/
void EndCapture(void)
{
	bThreadActive = FALSE;
	Sleep(1000);
	TerminateThread(hSniffThread, dwSniffThreadID);
	closesocket(sock);
}
/****************************************************************
sniffing thread
****************************************************************/
DWORD _stdcall SniffThread(void *param)
{
WSABUF wsb;
char rcvbuf[MAX_IP_SIZE];	

    wsb.buf = rcvbuf;	

	while (bThreadActive) {
	    wsb.len = MAX_IP_SIZE;
		memset(wsb.buf, 0x0, MAX_IP_SIZE);
		GetPacket(&wsb);
		CheckFilter(rcvbuf);
	}
	
	return 0;
}
/****************************************************************
init all and start sniffing thread
****************************************************************/
int StartCapture(int iAdapterNr, const char *szRulesFile)
{
	if (0 != InitializeCapture(iAdapterNr)) 
		return 1;
	if (0 != ParseFile(szRulesFile))
		return 2;
	bThreadActive = TRUE;
	if (NULL == (hSniffThread = CreateThread(NULL, 0, SniffThread, 0, 0, &dwSniffThreadID))) {
		sprintf(szErrorString, "Thread  creation failed!\n");
		AddToMessageLog(szErrorString, EVENTLOG_ERROR_TYPE);
		return 3;
	}
	SetThreadPriority(hSniffThread, THREAD_PRIORITY_HIGHEST);

	fprintf(stdout, "Capture started oK\nPress Ctrl+C to stop ...\n\n");
	return 0;	
}

