
#ifndef _PARSEFILE_H_
#define _PARSEFILE_H_

#include "gnu_regex_win32\regex.h"

/* flags */
#define FL_EXPRESSION	(1)
#define FL_SADDR		(2)
#define FL_DADDR		(4)
#define FL_SPORT		(8)
#define FL_DPORT		(16)
#define FL_FILE			(32)
#define FL_LOGTYPE		(64)
#define FL_PROTO		(128)
#define FL_MINSIZE		(256)
#define FL_MAXSIZE		(512)

/* not flags */
#define FL_EXPRESSION_NOT	(1024)
#define FL_SADDR_NOT		(2048)
#define FL_DADDR_NOT		(4096)
#define FL_SPORT_NOT		(8192)
#define FL_DPORT_NOT		(16384)
#define FL_PROTO_NOT		(32768)

typedef struct FREC {
	DWORD		dwFlags;					/* which flags are set */
	BYTE		byProto;					/* protocol info */
	DWORD		dwMinSize;					/* minimum packet size (header included) */
	DWORD		dwMaxSize;					/* maximum packet size (header included) */
	WORD		wSPort;						/* source port */
	WORD		wDPort;						/* destination port */
	DWORD		dwSAddr;					/* source IP address */
	DWORD		dwDAddr;					/* destination IP address */
	DWORD		dwSMask;					/* source IP address mask*/
	DWORD		dwDMask;					/* destination IP address mask*/
	regex_t		RE;							/* regular expression */
	BYTE		byLogType;					/* logging type */
	char		szLogFileName[_MAX_PATH];	/* Guess what ;) */
	DWORD		dwLine;						/* line info */
	struct FREC *next;						/* pointer to next */
} TSniffRule, *PSniffRule;

extern PSniffRule sniff_rules;
int ParseFile(const char *szRulesFile);
void ParseFileClear(void);

#endif