
/****************************************************************
daSniff - simple open source customizable sniffer for windows

Modifications of any kind are permitted ;)
Sending new code and ideas to stjordanov@hotmail.com will be appreciated

Author: Demosten - http://demosten.com (stjordanov@hotmail.com)

****************************************************************/

#include <stdio.h>
#include <winsock2.h>
#include <windows.h>
#include "daSniff.h"
#include "NetAdapterA.h"
#include "PacketCaptureA.h"
#include "ParseFile.h"
#include "Filter.h"
#include "Service.h"

char szErrorString[256]; // keeps error string of all files

static const char szSectionName[] = "OPTIONS";
static char szRulesFile[_MAX_PATH];
static int iAdapterNum = 0;
static HANDLE hServerStopEvent = NULL;
static SERVICE_TABLE_ENTRY dispatchTable[] = {
        { szServiceName, (LPSERVICE_MAIN_FUNCTION)service_main },
        { NULL, NULL }
};

/****************************************************************
 ShowUsage - show help info and quits (exit code 1)
****************************************************************/
void ShowUsage(void)
{
static char szUsage[] = "Usage: daSniffA_svc [option]\n\n"
"Default rules file name is 'daSniff.rules'\n"

"Options:\n"
"   -l : list possible device numbers (do not use # in <adapter_number>)\n"
"   -i : install service\n"
"   -r : remove service\n"
"   -g : debug service (run as console application)\n";

	fprintf(stdout, "%s", szUsage);
	exit(1);
}
/****************************************************************
 cleanup routines
****************************************************************/
void ServiceStop(void)
{
    if ((hServerStopEvent) && (!bDebug))
        SetEvent(hServerStopEvent);

	EndCapture();		/* stop capture */
	WSACleanup();		/* stop winsock */
	ParseFileClear();	/* clear rules memory */
	sprintf(szErrorString, "\nAll packets: %u, Logged: %u\n", 
		dwAllPackets, dwCapturedPackets);
	AddToMessageLog(szErrorString, EVENTLOG_INFORMATION_TYPE);
}
/****************************************************************
 CtrlCHandler () intercepts the CTRL+BREAK or CTRL+C events and calls the
 cleanup routines.
****************************************************************/
BOOL __stdcall CtrlCHandler(DWORD dwEvent)
{
	ServiceStop();
	fprintf(stdout, "\nInterrupted\n");
	exit(5);

    return TRUE;
}
/****************************************************************
 startup routines
****************************************************************/
BOOL Startup(void)
{
WSADATA wsadata;
DWORD dwVersion;

	dwVersion = GetVersion();
	if ((dwVersion >= 0x80000000) || (5 > LOBYTE(LOWORD(dwVersion)))) {
		AddToMessageLog("Windows 2000 or higher version is requred!\n", EVENTLOG_ERROR_TYPE);
		exit(10);
	}

	if (WSAStartup(0x202, &wsadata))	/* init winsock */
		return FALSE;

	/* init filter */	
	InitFilter();

	return TRUE;
}
/****************************************************************
read parameters from the .INI file
common name daSniffA_svc.ini
****************************************************************/
void ReadConfig(void)
{
char *pcPointPos, *pcSlashPos;
char szFileName[_MAX_PATH];

	// get .ini file name from path
	GetModuleFileName(NULL, szFileName, _MAX_PATH);
	pcPointPos = strchr(szFileName, '.');
	if (pcPointPos == NULL) {	// no '.' in file name
		strcat(szFileName, ".ini");
	}
	else {
		pcSlashPos = strchr(szFileName, '\\');
		// '\' is before '.' or no '\'
		if ((pcSlashPos == NULL) || (pcPointPos > pcSlashPos))
			*pcPointPos = 0;
		strcat(szFileName, ".ini");
	}

	// read settings
	GetPrivateProfileString(szSectionName, "rules_file", "daSniff.rules", 
		szRulesFile, _MAX_PATH, szFileName);
	iAdapterNum = GetPrivateProfileInt(szSectionName, "adapter_num", 0, szFileName);
	bDropEmptyPackets = GetPrivateProfileInt(szSectionName, "drop_empty", 0, szFileName);
	bStopOnMatch = GetPrivateProfileInt(szSectionName, "stop_on_match", 0, szFileName);
}
/****************************************************************
service starting routine (SericeMain)
****************************************************************/
void ServiceStart(DWORD dwArgc, LPTSTR *lpszArgv)
{
int iResilt;

	if (!ReportStatusToSCMgr(SERVICE_START_PENDING, NO_ERROR, 3000)) {
		ReportStatusToSCMgr(SERVICE_STOPPED, ERROR_SERVICE_SPECIFIC_ERROR, 0);
		return;
	}
	ReadConfig();
    if (!ReportStatusToSCMgr(SERVICE_START_PENDING, NO_ERROR, 3000)) {
		ReportStatusToSCMgr(SERVICE_STOPPED, ERROR_SERVICE_SPECIFIC_ERROR, 0);
		return;
	}
	if (iResilt = StartCapture(iAdapterNum, szRulesFile)) {
		ServiceStop();
		ReportStatusToSCMgr(SERVICE_STOPPED, ERROR_SERVICE_SPECIFIC_ERROR, 0);
		return;
	}
    if (!ReportStatusToSCMgr(SERVICE_RUNNING, NO_ERROR, 0)) {
		ReportStatusToSCMgr(SERVICE_STOPPED, ERROR_SERVICE_SPECIFIC_ERROR, 0);
		return;
	}
	// create the event object. The control handler function signals
    // this event when it receives the "stop" control code.
    hServerStopEvent = CreateEvent(NULL, TRUE, FALSE, NULL);

    WaitForSingleObject(hServerStopEvent, INFINITE);

    if (hServerStopEvent)
        CloseHandle(hServerStopEvent);
    ReportStatusToSCMgr(SERVICE_STOPPED, NO_ERROR, 0);
}
/****************************************************************
called when the service is running in debug mode
****************************************************************/
void CmdDebugService(int argc, char **argv)
{
    DWORD dwArgc;
    LPTSTR *lpszArgv;

#ifdef UNICODE
    lpszArgv = CommandLineToArgvW(GetCommandLineW(), &dwArgc);
#else
    dwArgc   = (DWORD)argc;
    lpszArgv = argv;
#endif

    if (FALSE == SetConsoleCtrlHandler((PHANDLER_ROUTINE)CtrlCHandler, TRUE))  
		fprintf(stderr, "SetConsoleCtrlHandler() failed: %u\n", GetLastError());

    bDebug = TRUE;

	fprintf(stdout, "daSniff (service) version 1.41.A - a customizable windows sniffer\n");
	fprintf(stdout, "Author: Demosten - http://demosten.com (stjordanov@hotmail.com)\n\n");
	
	SetPriorityClass(GetCurrentProcess(), HIGH_PRIORITY_CLASS);
	SetThreadPriority(GetCurrentThread(), THREAD_PRIORITY_LOWEST);

	ServiceStart(dwArgc, lpszArgv);

	exit(0);
}
/****************************************************************
 main() - Entry point
****************************************************************/
int main(int argc, char **argv)
{
	if (!Startup())
		return 8;
	// process argument
    if ( (argc > 1) &&  ((*argv[1] == '-') || (*argv[1] == '/')) ) {
		switch (*(argv[1] + 1)) {
		case 'h': 
		case '?': ShowUsage();
		case 'l': ListAdapters(); exit(3); 
		case 'g': CmdDebugService(argc, argv); 
		case 'i': CmdInstallService(); exit(6);
		case 'r': CmdRemoveService(); exit(7);
		} // switch
	}
	
    if (!StartServiceCtrlDispatcher(dispatchTable))
        AddToMessageLog("StartServiceCtrlDispatcher failed.", EVENTLOG_ERROR_TYPE);

	return 0;
}

