
/****************************************************************
daSniff - simple open source customizable sniffer for windows

Modifications of any kind are permitted ;)
Sending new code and ideas to stjordanov@hotmail.com will be appreciated

Author: Demosten - http://demosten.com (stjordanov@hotmail.com)

****************************************************************/

#include <stdio.h>
#include <winsock2.h>
#include "Filter.h"
#include "ParseFile.h"
#include "gnu_regex_win32\regex.h"

/* these characters are replaced with spaces in text part of 
the result shown from DumpBufferHexText() */
static const char szFrmChars[] = "\n\r\t\f\b\x07\x0B\0";

static char Protocol[256][20]={ 
		           "Reserved",     //  0
                   "ICMP",         //  1
                   "IGMP",         //  2
                   "GGP",          //  3
                   "IP",           //  4
                   "ST",           //  5
                   "TCP",          //  6
                   "UCL",          //  7
                   "EGP",          //  8
                   "IGP",          //  9
                   "BBN-RCC-MON",  // 10
                   "NVP-II",       // 11
                   "PUP",          // 12
                   "ARGUS",        // 13
                   "EMCON",        // 14
                   "XNET",         // 15
                   "CHAOS",        // 16
                   "UDP",          // 17
                   "MUX",          // 18
                   "DCN-MEAS",     // 19
                   "HMP",          // 20
                   "PRM",          // 21
                   "XNS-IDP",      // 22
                   "TRUNK-1",      // 23
                   "TRUNK-2",      // 24
                   "LEAF-1",       // 25
                   "LEAF-2",       // 26
                   "RDP",          // 27
                   "IRTP",         // 28
                   "ISO-TP4",      // 29
                   "NETBLT",       // 30
                   "MFE-NSP",      // 31
                   "MERIT-INP",    // 32
                   "SEP",          // 33
                   "3PC",          // 34
                   "IDPR",         // 35
                   "XTP",          // 36
                   "DDP",          // 37
                   "IDPR-CMTP",    // 38
                   "TP++",         // 39
                   "IL",           // 40
                   "SIP",          // 41
                   "SDRP",         // 42
                   "SIP-SR",       // 43
                   "SIP-FRAG",     // 44
                   "IDRP",         // 45
                   "RSVP",         // 46
                   "GRE",          // 47
                   "MHRP",         // 48
                   "BNA",          // 49
                   "SIPP-ESP",     // 50
                   "SIPP-AH",      // 51
                   "I-NLSP",       // 52
                   "SWIPE",        // 53
                   "NHRP",         // 54
                   "unknown (55)", // 55
                   "unknown (56)", // 56
                   "unknown (57)", // 57
                   "unknown (58)", // 58
                   "unknown (59)", // 59
                   "unknown (60)", // 60
                   "unknown (61)", // 61
                   "CFTP",         // 62
                   "unknown (63)", // 63
                   "SAT-EXPAK",    // 64
                   "KRYPTOLAN",    // 65
                   "RVD",          // 66
                   "IPPC",         // 67
                   "unknown (68)", // 68
                   "SAT-MON",      // 69
                   "VISA",         // 70
                   "IPCV",         // 71
                   "CPNX",         // 72
                   "CPHB",         // 73
                   "WSN",          // 74
                   "PVP",          // 75
                   "BR-SAT-MON",   // 76
                   "SUN-ND",       // 77
                   "WB-MON",       // 78
                   "WB-EXPAK",     // 79
                   "ISO-IP",       // 80
                   "VMTP",         // 81
                   "SECURE-VMTP",  // 82
                   "VINES",        // 83
                   "TTP",          // 84
                   "NSFNET-IGP",   // 85
                   "DGP",          // 86
                   "TCF",          // 87
                   "IGRP",         // 88
                   "OSPFIGP",      // 89
                   "Sprite-RPC",   // 90
                   "LARP",         // 91
                   "MTP",          // 92
                   "AX.25",        // 93
                   "IPIP",         // 94
                   "MICP",         // 95
                   "SCC-SP",       // 96
                   "ETHERIP",      // 97
                   "ENCAP",        // 98
                   "unknown (99)", // 99
                   "GMTP"          // 100
                  };

/* Global variables */
DWORD dwAllPackets = 0;				/* all received packets number */
DWORD dwCapturedPackets = 0;		/* all captured packets number */
BOOL bDropEmptyPackets = FALSE;		/* if TRUE empty packets will not be checked */
BOOL bStopOnMatch = FALSE;			/* if TRUE checker will stop on first rule match */

/****************************************************************
Show write information in pBuf (dwLen bytes long) to file (fh) 
formated as byte size HEX values
Format: 1. offset 2. HEX values (16 per line)
****************************************************************/
void DumpBufferHex(const BYTE *pBuf, DWORD dwLen, FILE *fh)
{
DWORD dwCounter, dwCnt;

	for (dwCounter = 0; dwCounter < dwLen / 16; dwCounter++)
		fprintf(fh, "%08x %02x %02x %02x %02x %02x %02x %02x %02x %02x %02x %02x %02x %02x %02x %02x %02x\n",
			dwCounter * 16, pBuf[dwCounter * 16 + 0], pBuf[dwCounter * 16 + 1],
			pBuf[dwCounter * 16 + 2],pBuf[dwCounter * 16 + 3], pBuf[dwCounter * 16 + 4],
			pBuf[dwCounter * 16 + 5],pBuf[dwCounter * 16 + 6], pBuf[dwCounter * 16 + 7],
			pBuf[dwCounter * 16 + 8],pBuf[dwCounter * 16 + 9], pBuf[dwCounter * 16 + 10],
			pBuf[dwCounter * 16 + 11],pBuf[dwCounter * 16 + 12], pBuf[dwCounter * 16 + 13],
			pBuf[dwCounter * 16 + 14],pBuf[dwCounter * 16 + 15]);
	if (dwLen % 16 != 0) {
		fprintf(fh, "%08x ", dwCounter * 16);
		for (dwCnt = 0; dwCnt < dwLen % 16; dwCnt++)
			fprintf(fh, "%02x ", pBuf[dwCounter * 16 + dwCnt]);
		fprintf(fh, "\n");
	}
}
/****************************************************************
Show write information in pBuf (dwLen bytes long) to file (fh) 
formated as byte size HEX values followed by the plain text
Format: 1. offset 2. HEX values (16 per line) 3. Plain text chars (16 per line)
****************************************************************/
void DumpBufferHexText(const BYTE *pBuf, DWORD dwLen, FILE *fh)
{
DWORD dwCounter, dwCnt;

	for (dwCounter = 0; dwCounter < dwLen / 16; dwCounter++) {
		fprintf(fh, "%08x %02x %02x %02x %02x %02x %02x %02x %02x %02x %02x %02x %02x %02x %02x %02x %02x ",
			dwCounter * 16, pBuf[dwCounter * 16], pBuf[dwCounter * 16 + 1],
			pBuf[dwCounter * 16 + 2], pBuf[dwCounter * 16 + 3], pBuf[dwCounter * 16 + 4],
			pBuf[dwCounter * 16 + 5], pBuf[dwCounter * 16 + 6], pBuf[dwCounter * 16 + 7],
			pBuf[dwCounter * 16 + 8], pBuf[dwCounter * 16 + 9], pBuf[dwCounter * 16 + 10],
			pBuf[dwCounter * 16 + 11], pBuf[dwCounter * 16 + 12], pBuf[dwCounter * 16 + 13],
			pBuf[dwCounter * 16 + 14], pBuf[dwCounter * 16 + 15]);

		for (dwCnt = 0; dwCnt < 16; dwCnt++)
			if (strchr(szFrmChars, pBuf[dwCounter * 16 + dwCnt]))
				fputc(' ', fh);
			else
				fputc(pBuf[dwCounter * 16 + dwCnt], fh);

		fprintf(fh, "\n");
	}
	if (dwLen % 16 != 0) {
		fprintf(fh, "%08x ", dwCounter * 16);
		for (dwCnt = 0; dwCnt < dwLen % 16; dwCnt++)
			fprintf(fh, "%02x ", pBuf[dwCounter * 16 + dwCnt]);
		for (;dwCnt < 16; dwCnt++)
			fprintf(fh, "   ");
		for (dwCnt = 0; dwCnt < dwLen % 16; dwCnt++)
			if (strchr(szFrmChars, pBuf[dwCounter * 16 + dwCnt]))
				fputc(' ', fh);
			else
				fputc(pBuf[dwCounter * 16 + dwCnt], fh);
		fprintf(fh, "\n");
	}
}
/****************************************************************
Show write information in pBuf (dwLen bytes long) to file (fh) 
formated as plain text
****************************************************************/
void DumpBufferText(const BYTE *pBuf, DWORD dwLen, FILE *fh)
{
	fwrite(pBuf, 1, dwLen, fh);
}
/****************************************************************
Print standard header information:
1. time and date 2. rule line number
3. protocol name 4. total packet length 5. source ip & port 6. destination ip & port
note: in protocols without source and destonation ports (such as IP) this information
      is invalid
****************************************************************/
void PrintStartInfo(const BYTE *wsb, DWORD dwRuleLine, FILE *fh)
{
SYSTEMTIME now;
	GetLocalTime(&now);
	fprintf(fh, "\n[%02d:%02d:%02d - %02d.%02d.%d] - rule line %d\n",
		now.wHour, now.wMinute, now.wSecond, 
		now.wDay, now.wMonth, now.wYear,
		dwRuleLine);
	fprintf(fh, "Proto: %s ", Protocol[*(wsb + 9)]); /* protocol info */
	fprintf(fh, "len: %d ", ntohs(*(WORD *)(wsb + 2))); /* total length */
	fprintf(fh, "%d.%d.%d.%d:%d -> %d.%d.%d.%d:%d \n\n", 
		wsb[12], wsb[13], wsb[14], wsb[15], ntohs(*(WORD *)(wsb + 20)),
		wsb[16], wsb[17], wsb[18], wsb[19], ntohs(*(WORD *)(wsb + 22)));
}
/****************************************************************
return length of header of protocol byProto
note: ICMP has 28 bytes header (IP + ICMP) but if the ICMP code 
	  is Timestamp or Timestamp Reply it is 40 bytes ...so I always 
	  print the whole header info
****************************************************************/
DWORD GetHdrLenByProto(BYTE byProto)
{
	switch (byProto) {
	case 4: return 20;		/* IP */
	case 17: return 28;		/* UDP */
	case 6: return 40;		/* TCP */
	case 2: return 28;		/* IGMP */
	}
	return 0;
}
/****************************************************************
check filter wsb acourding rules found in sniff_rules
****************************************************************/
void CheckFilter(const BYTE *wsb)
{
PSniffRule sr = sniff_rules;
DWORD dwHdrLen, dwPktLen, dwIP;
BYTE byProto;
FILE *fh;

	dwAllPackets++;
	for (sr = sniff_rules; NULL != sr; sr = sr->next) {
		byProto = wsb[9];
		dwHdrLen = GetHdrLenByProto(byProto);
		dwPktLen = (DWORD)ntohs(*(WORD *)(wsb + 2));
		if ((bDropEmptyPackets) && (dwHdrLen >= dwPktLen)) /* drop no-data packets */
			break;
		if ((sr->dwFlags & FL_PROTO) && (sr->byProto != byProto))
			continue;
		if ((sr->dwFlags & FL_PROTO_NOT) && (sr->byProto == byProto))
			continue;
		if ((sr->dwFlags & FL_MINSIZE) && (sr->dwMinSize > dwPktLen))
			continue;
		if ((sr->dwFlags & FL_MAXSIZE) && (sr->dwMaxSize < dwPktLen))
			continue;
		if (sr->dwFlags & FL_SADDR) {
			dwIP = *(DWORD *)(wsb + 12);
			dwIP &= sr->dwSMask;
			if (dwIP != sr->dwSAddr)
				continue;
		}
		if (sr->dwFlags & FL_SADDR_NOT) {
			dwIP = *(DWORD *)(wsb + 12);
			dwIP &= sr->dwSMask;
			if (dwIP == sr->dwSAddr)
				continue;
		}
		if (sr->dwFlags & FL_DADDR) {
			dwIP = *(DWORD *)(wsb + 16);
			dwIP &= sr->dwDMask;
			if (dwIP != sr->dwDAddr)
				continue;
		}
		if (sr->dwFlags & FL_DADDR_NOT) {
			dwIP = *(DWORD *)(wsb + 16);
			dwIP &= sr->dwDMask;
			if (dwIP == sr->dwDAddr)
				continue;
		}
		if ((sr->dwFlags & FL_SPORT) && (sr->wSPort != *(WORD *)(wsb + 20)))
			continue;
		if ((sr->dwFlags & FL_SPORT_NOT) && (sr->wSPort == *(WORD *)(wsb + 20)))
			continue;
		if ((sr->dwFlags & FL_DPORT) && (sr->wDPort != *(WORD *)(wsb + 22)))
			continue;
		if ((sr->dwFlags & FL_DPORT_NOT) && (sr->wDPort == *(WORD *)(wsb + 22)))
			continue;
		if ((sr->dwFlags & FL_EXPRESSION) && 
			(0 > re_search_2(&sr->RE, NULL, 0, (wsb + dwHdrLen), dwPktLen - dwHdrLen, 0, dwPktLen - dwHdrLen, NULL)))
				continue;
		if ((sr->dwFlags & FL_EXPRESSION_NOT) && 
			(0 <= re_search_2(&sr->RE, NULL, 0, (wsb + dwHdrLen), dwPktLen - dwHdrLen, 0, dwPktLen - dwHdrLen, NULL)))
				continue;
		
		dwCapturedPackets++;
		/* open file to log to */
		fh = NULL;
		if (sr->dwFlags & FL_FILE) {
			if (0 == strcmp(sr->szLogFileName, "-"))
				fh = stdout;
			else {
				fh = fopen(sr->szLogFileName, "a+");
			}
		}
		if (fh == NULL)
			fh = stdout;

		/* print to file */
		PrintStartInfo(wsb, sr->dwLine, fh); /* standard header */

		switch (sr->byLogType) {
		case 1: DumpBufferText(wsb, dwPktLen, fh); break;
		case 2: DumpBufferHex(wsb, dwPktLen, fh); break;
		case 3: DumpBufferHexText(wsb + dwHdrLen, dwPktLen - dwHdrLen, fh); break;
		case 4: DumpBufferText(wsb + dwHdrLen, dwPktLen - dwHdrLen, fh); break;
		case 5: DumpBufferHex(wsb + dwHdrLen, dwPktLen - dwHdrLen, fh); break;
		case 6: break;
		default: DumpBufferHexText(wsb, dwPktLen, fh);
		}
		
		if (fh != stdout) /* close file */
			fclose(fh);
		
		if (bStopOnMatch) /* stop on first match */
			break;
	}
}

/****************************************************************
init filter - filter initialization functions
****************************************************************/
void InitFilter()
{
int index;

	for (index = 101; index < 256; index++)
		sprintf(Protocol[index], "unknown (%d)", index);
}
