
/****************************************************************
daSniff - simple open source customizable sniffer for windows

Modifications of any kind are permitted ;)
Sending new code and ideas to stjordanov@hotmail.com will be appreciated

Author: Demosten - http://demosten.com (stjordanov@hotmail.com)

****************************************************************/

#include <stdio.h>
#include "NetAdapterB.h"
#include "WPdpack\Include\packet32.h"

char AdapterList[MAX_NUM_ADAPTER][1024];
int iAdapterNum = 0;

/****************************************************************
list all available net adapters by address
return number of adpapters avaiable
****************************************************************/
int GetAdapterList(void)
{
#define ADAPTER_LENGTH	(10000)
DWORD dwVersion, dwWindowsMajorVersion, dwAdapterLength = ADAPTER_LENGTH;

// unicode strings (winnt) 
WCHAR		AdapterName[ADAPTER_LENGTH]; // string that contains a list of the network adapters
WCHAR		*temp;

// ascii strings (win95)
char		AdapterNamea[ADAPTER_LENGTH]; // string that contains a list of the network adapters
char		*tempa;

	/* the data returned by PacketGetAdapterNames is different in Win95 and in WinNT.
	 We have to check the os on which we are running */
	dwVersion = GetVersion();
	dwWindowsMajorVersion = (DWORD)(LOBYTE(LOWORD(dwVersion)));
	if (!(dwVersion >= 0x80000000 && dwWindowsMajorVersion >= 4)) {  // Windows NT 
		#pragma warning( disable : 4133 )
		PacketGetAdapterNames(AdapterName, &dwAdapterLength);
		#pragma warning( default : 4133 )
		temp = AdapterName;
		while (*temp != 0) {
			wcscpy((WCHAR *)&AdapterList[iAdapterNum][0], temp);
			temp += wcslen(temp);
			temp++;
			iAdapterNum++;
		}
	}
	else { // windows 9x 
		PacketGetAdapterNames(AdapterNamea, &dwAdapterLength);
		tempa = AdapterNamea;
		while (*tempa != 0) {
			strcpy(&AdapterList[iAdapterNum][0], tempa);
			tempa += strlen(tempa);
			tempa++;
			iAdapterNum++;
		}
	}
	return iAdapterNum;
}
/****************************************************************
list all available net adapters by address
return number of adpapters avaiable
****************************************************************/
int ListAdapters(void)
{
int iCounter;
DWORD dwVersion, dwWindowsMajorVersion;

	dwVersion = GetVersion();
	dwWindowsMajorVersion = (DWORD)(LOBYTE(LOWORD(dwVersion)));
	if (!(dwVersion >= 0x80000000 && dwWindowsMajorVersion >= 4)) {  // Windows NT 
		for (iCounter = 0; iCounter < iAdapterNum; iCounter++)
			fwprintf(stdout, L"#%d  ->  %s\n", iCounter, (WCHAR *)&AdapterList[iCounter][0]);
	}
	else { // windows 9x 
		for (iCounter = 0; iCounter < iAdapterNum; iCounter++)
			fprintf(stdout, "#%d  ->  %s\n", iCounter, &AdapterList[iCounter][0]);
	}
	fprintf(stdout, "\n");
	return iAdapterNum;
}