
/****************************************************************
daSniff - simple open source customizable sniffer for windows

Modifications of any kind are permitted ;)
Sending new code and ideas to stjordanov@hotmail.com will be appreciated

Author: Demosten - http://demosten.com (stjordanov@hotmail.com)

****************************************************************/

#include <stdio.h>
#include "WPdpack\Include\packet32.h"
#include "WPdpack\Include\ntddndis.h"
#include <windows.h>
#include "daSniff.h"
#include "PacketCaptureB.h"
#include "NetAdapterB.h"
#include "ParseFile.h"
#include "Filter.h"

#ifndef __NetBSD__
#define BPF_ALIGNMENT sizeof(int)
#else
#define BPF_ALIGNMENT sizeof(long)
#endif
#define BPF_WORDALIGN(x) (((x)+(BPF_ALIGNMENT-1))&~(BPF_ALIGNMENT-1))


#define BUFFER_SIZE		(262144)	/* 256k */

// local file vars
static int iLanDataOffset;			/* offset of IP data in LAN data frame */
static BOOL bThreadActive = TRUE;	/* is the thread active? */
static HANDLE hSniffThread;			/* sniff-thread handle */
static DWORD dwSniffThreadID;		/* sniff-thread id */
LPADAPTER  lpAdapter = 0;			/* define a pointer to an ADAPTER structure */
LPPACKET   lpPacket;				/* define a pointer to a PACKET structure */
char buffer[BUFFER_SIZE];			/* buffer to hold the data coming from the driver */

/****************************************************************
Check network type and specify an offset of real data in iLanDataOffset
****************************************************************/
int GetLanType(void)
{
BOOL bResult;
NetType stNetType;

	bResult = PacketGetNetType(lpAdapter, &stNetType);
	if (bResult) {
		switch (stNetType.LinkType) {
		case NdisMedium802_5: iLanDataOffset = 22; return 0; // Token Ring (802.5) 
		//case NdisMedium802_3: iLanDataOffset = 14; return 0; // Ethernet (802.3)
		default: iLanDataOffset = 14; return 0; // Ethernet (802.3) ??? and others
		}
	}
	sprintf(szErrorString, "Cannot get network type!\n"); 
	AddToMessageLog(szErrorString, EVENTLOG_ERROR_TYPE);
	return 3;
}
/****************************************************************
create sniffing socket and bind it to the adapter iAdapterNr
****************************************************************/
int InitializeCapture(int iAdapterNr)
{
	lpAdapter = PacketOpenAdapter(AdapterList[iAdapterNr]);
	
	if (!lpAdapter || (lpAdapter->hFile == INVALID_HANDLE_VALUE)) {
		sprintf(szErrorString, "Unable to open the driver, Error Code : %u\n", GetLastError()); 
		AddToMessageLog(szErrorString, EVENTLOG_ERROR_TYPE);
		return 1;
	}	

	/* set the network adapter in promiscuous mode */
	PacketSetHwFilter(lpAdapter, NDIS_PACKET_TYPE_PROMISCUOUS);

	/* set a 512K buffer in the driver */
	PacketSetBuff(lpAdapter, 512 * 1024);

	/* set a 1 second read timeout */
	PacketSetReadTimeout(lpAdapter, 1000);
	
	/* allocate and initialize a packet structure that will be used to
	   receive the packets. */
	if (NULL == (lpPacket = PacketAllocatePacket())) {
		sprintf(szErrorString, "Error: failed to allocate the LPPACKET structure.\n");
		AddToMessageLog(szErrorString, EVENTLOG_ERROR_TYPE);
		return 2;
	}
	PacketInitPacket(lpPacket, (char*)buffer, BUFFER_SIZE);
	
	return GetLanType();
}
/****************************************************************
stop sniffing thread and close sniffing socket
****************************************************************/
void EndCapture(void)
{
	if (bThreadActive) {
		bThreadActive = FALSE;
		Sleep(500);
		TerminateThread(hSniffThread, dwSniffThreadID);
		// free packet space
		PacketCloseAdapter(lpAdapter);
		PacketFreePacket(lpPacket);
	}
}
/****************************************************************
sniffing thread
****************************************************************/
DWORD _stdcall SniffThread(void *param)
{
BYTE *wsb, *pbyBeginBuf, *pbyEndBuf;
int iCapLen, iHdrLen;

	while (bThreadActive) {
		if (PacketReceivePacket(lpAdapter, lpPacket, TRUE)) {
			pbyBeginBuf = lpPacket->Buffer;
			pbyEndBuf = pbyBeginBuf + lpPacket->ulBytesReceived;
			while (pbyBeginBuf < pbyEndBuf) {
				iCapLen = ((struct bpf_hdr *)pbyBeginBuf)->bh_caplen;
				iHdrLen = ((struct bpf_hdr *)pbyBeginBuf)->bh_hdrlen;
				wsb = pbyBeginBuf + iHdrLen + iLanDataOffset;
				if (0x45 == *wsb)  /* IP packets only plz */
					CheckFilter(wsb);
				pbyBeginBuf += BPF_WORDALIGN(iCapLen + iHdrLen);
			}
		}
	}
	
	return 0;
}
/****************************************************************
init all and start sniffing thread
****************************************************************/
int StartCapture(int iAdapterNr, const char *szRulesFile)
{
	if (0 != InitializeCapture(iAdapterNr)) 
		return 1;
	if (0 != ParseFile(szRulesFile))
		return 1;
	bThreadActive = TRUE;
	if (NULL == (hSniffThread = CreateThread(NULL, 0, SniffThread, 0, 0, &dwSniffThreadID))) {
		sprintf(szErrorString, "Thread  creation failed!\n");
		AddToMessageLog(szErrorString, EVENTLOG_ERROR_TYPE);
		return 1;
	}
	SetThreadPriority(hSniffThread, THREAD_PRIORITY_HIGHEST);

	fprintf(stdout, "Capture started oK\nPress Ctrl+C to stop ...\n\n");
	return 0;	
}

