
/****************************************************************
daSniff - simple open source customizable sniffer for windows

Modifications of any kind are permitted ;)
Sending new code and ideas to stjordanov@hotmail.com will be appreciated

Author: Demosten - http://demosten.com (stjordanov@hotmail.com)

****************************************************************/

#include <stdio.h>
#include <winsock2.h>
#include <windows.h>
#include "daSniff.h"
#include "gnu_regex_win32\regex.h"
#include "ParseFile.h"

PSniffRule sniff_rules = NULL;

#define BUF_SIZE	(512)
#define SMALL_BUF	(128)

/****************************************************************
 Strips ' ' from the begining and ' ' CR and LF from the end
****************************************************************/
void StripCRLF(char *szBuf)
{
int iLen = strlen(szBuf);
	/* Strip CR LF and spaces in the end */
	if (iLen)
		do {
			iLen--;
			if ((szBuf[iLen] == 0x0D) || (szBuf[iLen] == 0x0A) || (szBuf[iLen] == ' '))
				szBuf[iLen] = 0;
			else
				break;
		} while (iLen);
	/* Strip spaces from the begining */
	iLen = strlen(szBuf);
	if (iLen) {
		for (iLen = 0; iLen < (int)strlen(szBuf); iLen++)
			if (szBuf[iLen] != ' ')
				break;
		if ((iLen != (int)strlen(szBuf)) && (iLen != 0)) {
			int iCounter;
			for (iCounter = 0; iCounter <= (int)strlen(szBuf)-iLen; iCounter++)
				szBuf[iCounter] = szBuf[iCounter+iLen];
		}
	}
}
/****************************************************************
get string from dwStart to dwEnd and put it as zero terminated string in szBuf
return 0 on success
****************************************************************/
int GetString(char *szBuf, DWORD dwBufSize, const char *szSrc, DWORD dwStart, DWORD dwEnd)
{
DWORD dwSize = dwEnd - dwStart;
	if ((dwSize + 1) > dwBufSize)
		return 1;
	memcpy(szBuf, &szSrc[dwStart], dwSize);
	szBuf[dwSize] = 0;
	return 0;
}
/****************************************************************
get contents of parameter in szParameter (ex: "saddr=") and put it in szBuf
stops on first space or end of line
return 0 on success
****************************************************************/
int GetParameter(char *szBuf, DWORD dwBufSize, const char *szSrc, const char *szParameter)
{
char *szPos, *szSpace;
	if ((szPos = strstr(szSrc, szParameter))) {
		szPos += strlen(szParameter);
		if ('"' == *szPos) {
			szPos++;
			if ((szSpace = strchr(szPos, '"')))
				return GetString(szBuf, dwBufSize, szPos, 0, szSpace - szPos);
			else
				return 1;
		}
		else
			if ((szSpace = strchr(szPos, ' ')))
				return GetString(szBuf, dwBufSize, szPos, 0, szSpace - szPos);
			else
				return GetString(szBuf, dwBufSize, szPos, 0, strlen(szPos));
	}
	return 1;
}
/****************************************************************
get contents of parameter in szParameter (ex: "saddr") and put it in szBuf
check for = and != parameters (ex: saddr= and saddr!=)
return bNot = TRUE if operation is != (bNot = FALSE if operation is =)
return 0 on success
****************************************************************/
int GetFullParameter(char *szBuf, DWORD dwBufSize, BOOL *bNot, const char *szSrc, const char *szParameter)
{
int iResult;
char szBuffer[200];

	if (200 <= strlen(szParameter))
		return 1;
	strcpy(szBuffer, szParameter);
	strcat(szBuffer, "=");
	iResult = GetParameter(szBuf, dwBufSize, szSrc, szBuffer);
	if (0 == iResult) {
		*bNot = FALSE;
		return 0;
	}
	strcpy(szBuffer, szParameter);
	strcat(szBuffer, "!=");
	iResult = GetParameter(szBuf, dwBufSize, szSrc, szBuffer);
	if (0 == iResult) {
		*bNot = TRUE;
		return 0;
	}
	return 1;
}
/****************************************************************
GetHostMask() - tries to resolve host masks like 1.2.3.4/5
return INADDR_NONE on error
****************************************************************/
DWORD GetHostMask(const char *szHost, DWORD *pdwMask)
{
DWORD p1, p2, p3, p4, dwIP, dwBits;
int iResult, iResult2 = 1;
char *szSlash;
	
	dwBits = 0;
	szSlash = strchr(szHost, '/');
	if (NULL != szSlash) {
		szSlash++;
		iResult2 = sscanf(szSlash, "%u", &dwBits);
	}
	p1 = p2 = p3 = p4 = dwIP = 0;
	iResult = sscanf(szHost, "%u.%u.%u.%u", &p1, &p2, &p3, &p4);
	if ((0 == iResult) || (0 == iResult2) ||
		(255 < p1) || (255 < p2) || (255 < p3) || (255 < p4) || 
		(32 < dwBits) || (0 == dwBits)) 
		return INADDR_NONE;
	dwIP = (p4 << 24) | (p3 << 16) | (p2 << 8) | p1;
	dwBits = 32 - dwBits;
	if (32 == dwBits)
		*pdwMask = 0;
	else {
		*pdwMask = (DWORD)(0xFFFFFFFFL >> dwBits);
		dwIP &= *pdwMask;
	}

	return dwIP;
}
/****************************************************************
GetHostIp() - string (ip or hostname) to DWORD IP
return INADDR_NONE on error
****************************************************************/
DWORD GetHostIP(const char *szHost, DWORD *pdwMask)
{
DWORD dwIP;
LPHOSTENT lpHost;

	// Lookup host
	*pdwMask = 0xFFFFFFFFL;
	dwIP = inet_addr(szHost);
	if (dwIP == INADDR_NONE) {
		if (NULL != strchr(szHost, '/'))
			dwIP = GetHostMask(szHost, pdwMask);
		else {
			lpHost = gethostbyname(szHost);
			if (lpHost == NULL)
				dwIP = INADDR_NONE;
			else
				dwIP = *((unsigned long *)lpHost->h_addr);
		}
		if (INADDR_NONE == dwIP) { 
			sprintf(szErrorString, "invalid host or ip: %s\n", szHost);
			AddToMessageLog(szErrorString, EVENTLOG_ERROR_TYPE);
		}
	}
	return dwIP;
}
/****************************************************************
GetPort() - string (port) to WORD (big-endian format)
return 0 on error
****************************************************************/
WORD GetPort(const char *szPort)
{
WORD wPort;
	if ((wPort = atoi(szPort))) {
		return htons(wPort);
	}
	return 0;
}
/****************************************************************
parse file szRulesFile - return 0 on success
****************************************************************/
int ParseFile(const char *szRulesFile)
{
FILE *fh;
char szTemp[BUF_SIZE], szBuffer[BUF_SIZE], szError[SMALL_BUF];
int iResult, iTotalResult = 0;
char *szExpression;
PSniffRule pNewRule, *ppNewRule = &sniff_rules;
DWORD dwIP, dwCurLine = 0;
WORD wPort;
BOOL bNot;
	
	if (NULL == (fh = fopen(szRulesFile, "rt"))) {
		sprintf(szErrorString, "Cannot open file: %s\n", szRulesFile);
		AddToMessageLog(szErrorString, EVENTLOG_ERROR_TYPE);
		return 1;
	}
	fprintf(stdout, "Parsing file: %s\n", szRulesFile);
	while (fgets(szBuffer, BUF_SIZE, fh) != NULL) {
		dwCurLine++;
		StripCRLF(szBuffer);
		if ((strlen(szBuffer) < 2) || ('#' == szBuffer[0]))
			continue;
		
		/* get memory */
		if (NULL == (pNewRule = malloc(sizeof(TSniffRule)))) {
			sprintf(szErrorString, "Cannot allocate memory\n");
			AddToMessageLog(szErrorString, EVENTLOG_ERROR_TYPE);
			iTotalResult = 5;
			break;
		}
		memset(pNewRule, 0, sizeof(TSniffRule));

		/* get expression if found */
		if ((szExpression = strstr(szBuffer, "expr="))) {
			*szExpression = 0; /* remove expression from current line */
			szExpression += 5; /* goto exact expression */
			if ((iResult = regcomp(&pNewRule->RE, szExpression, REG_EXTENDED | REG_NOSUB))) {
				regerror(iResult, &pNewRule->RE, szError, SMALL_BUF);
				fprintf(stderr, "regcomp: %s\n", szError);
				iTotalResult = 2;
				break;
			}
			pNewRule->dwFlags |= FL_EXPRESSION;
		}
		/* get NOT expression if found */
		else if ((szExpression = strstr(szBuffer, "expr!="))) { 
			*szExpression = 0; /* remove expression from current line */
			szExpression += 6; /* goto exact expression */
			if ((iResult = regcomp(&pNewRule->RE, szExpression, REG_EXTENDED | REG_NOSUB))) {
				regerror(iResult, &pNewRule->RE, szError, SMALL_BUF);
				fprintf(stderr, "regcomp: %s\n", szError);
				iTotalResult = 2;
				break;
			}
			pNewRule->dwFlags |= FL_EXPRESSION_NOT;
		}
		/* get case ignore expression if found */
		else if ((szExpression = strstr(szBuffer, "expri=")) && !(pNewRule->dwFlags & FL_EXPRESSION)) {
			*szExpression = 0; /* remove expression from current line */
			szExpression += 6; /* goto exact expression */
			if ((iResult = regcomp(&pNewRule->RE, szExpression, 
								REG_EXTENDED | REG_ICASE | REG_NOSUB))) {
				regerror(iResult, &pNewRule->RE, szError, SMALL_BUF);
				fprintf(stderr, "regcomp: %s\n", szError);
				iTotalResult = 2;
				break;
			}
			pNewRule->dwFlags |= FL_EXPRESSION;
		}
		/* get case ignore NOT expression if found */
		else if ((szExpression = strstr(szBuffer, "expri!=")) && !(pNewRule->dwFlags & FL_EXPRESSION)) {
			*szExpression = 0; /* remove expression from current line */
			szExpression += 7; /* goto exact expression */
			if ((iResult = regcomp(&pNewRule->RE, szExpression, 
								REG_EXTENDED | REG_ICASE | REG_NOSUB))) {
				regerror(iResult, &pNewRule->RE, szError, SMALL_BUF);
				fprintf(stderr, "regcomp: %s\n", szError);
				iTotalResult = 2;
				break;
			}
			pNewRule->dwFlags |= FL_EXPRESSION_NOT;
		}

		/* get protocol */
		if (!GetFullParameter(szTemp, BUF_SIZE, &bNot, szBuffer, "proto")) {
			if (0 == stricmp(szTemp, "udp")) {
				pNewRule->byProto = 17; // UDP
				(bNot) ? (pNewRule->dwFlags |= FL_PROTO_NOT) : (pNewRule->dwFlags |= FL_PROTO);
			}
			else if (0 == stricmp(szTemp, "tcp")) {
				pNewRule->byProto = 6; // TCP
				(bNot) ? (pNewRule->dwFlags |= FL_PROTO_NOT) : (pNewRule->dwFlags |= FL_PROTO);
			}
			else if (0 == stricmp(szTemp, "icmp")) {
				pNewRule->byProto = 1; // ICMP
				(bNot) ? (pNewRule->dwFlags |= FL_PROTO_NOT) : (pNewRule->dwFlags |= FL_PROTO);
			}
			else if (0 == stricmp(szTemp, "igmp")) {
				pNewRule->byProto = 2; // IGMP
				(bNot) ? (pNewRule->dwFlags |= FL_PROTO_NOT) : (pNewRule->dwFlags |= FL_PROTO);
			}
		}

		/* get addresses */
		if (!GetFullParameter(szTemp, BUF_SIZE, &bNot, szBuffer, "saddr")) {
			if (INADDR_NONE != (dwIP = GetHostIP(szTemp, &(pNewRule->dwSMask)))) {
				pNewRule->dwSAddr = dwIP;
				(bNot) ? (pNewRule->dwFlags |= FL_SADDR_NOT) : (pNewRule->dwFlags |= FL_SADDR);
			}
		}
		if (!GetFullParameter(szTemp, BUF_SIZE, &bNot, szBuffer, "daddr")) {
			if (INADDR_NONE != (dwIP = GetHostIP(szTemp, &(pNewRule->dwDMask)))) {
				pNewRule->dwDAddr = dwIP;
				(bNot) ? (pNewRule->dwFlags |= FL_DADDR_NOT) : (pNewRule->dwFlags |= FL_DADDR);
			}
		}
		
		/* get ports */
		if (!GetFullParameter(szTemp, BUF_SIZE, &bNot, szBuffer, "sport")) {
			if (0 != (wPort = GetPort(szTemp))) {
				pNewRule->wSPort = wPort;
				(bNot) ? (pNewRule->dwFlags |= FL_SPORT_NOT) : (pNewRule->dwFlags |= FL_SPORT);
			}
		}
		if (!GetFullParameter(szTemp, BUF_SIZE, &bNot, szBuffer, "dport")) {
			if (0 != (wPort = GetPort(szTemp))) {
				pNewRule->wDPort = wPort;
				(bNot) ? (pNewRule->dwFlags |= FL_DPORT_NOT) : (pNewRule->dwFlags |= FL_DPORT);
			}
		}

		/* get file */
		if (!GetParameter(szTemp, BUF_SIZE, szBuffer, "file=")) {
			strncpy(pNewRule->szLogFileName, szTemp, _MAX_PATH);
			pNewRule->dwFlags |= FL_FILE;
		}

		/* get logtype */
		if (!GetParameter(szTemp, BUF_SIZE, szBuffer, "logtype=")) {
			pNewRule->byLogType = (BYTE)atoi(szTemp);
			pNewRule->dwFlags |= FL_LOGTYPE;
		}

		/* get minsize */
		if (!GetParameter(szTemp, BUF_SIZE, szBuffer, "minsize=")) {
			pNewRule->dwMinSize = 0;
			pNewRule->dwMinSize = strtoul(szTemp, NULL, 10);
			if (0 != pNewRule->dwMinSize)
				pNewRule->dwFlags |= FL_MINSIZE;
		}

		/* get maxsize */
		if (!GetParameter(szTemp, BUF_SIZE, szBuffer, "maxsize=")) {
			pNewRule->dwMaxSize = 0;
			pNewRule->dwMaxSize = strtoul(szTemp, NULL, 10);
			if (0 != pNewRule->dwMaxSize)
				pNewRule->dwFlags |= FL_MAXSIZE;
		}

		pNewRule->dwLine = dwCurLine; /* set line number */

		// add the new rule
			// tail (FIFO)
		*ppNewRule = pNewRule;
		ppNewRule = &(pNewRule->next);
			// stack (LIFO)
		//pNewRule->next = sniff_rules;
		//sniff_rules = pNewRule;

	}
	fclose(fh);
	fprintf(stdout, "Parsing file done.\n\n");
	return iTotalResult;
}

/****************************************************************
Clears reserverd rules memory
****************************************************************/
void ParseFileClear(void)
{
PSniffRule pTemp, *ppReal;

	/* free rules memory */
	ppReal = &sniff_rules;
	while (*ppReal)	{
		pTemp = (*ppReal)->next;
		free(*ppReal);
		*ppReal = pTemp;
	}
	*ppReal = NULL;
}
