
/****************************************************************
daSniff - simple open source customizable sniffer for windows

Modifications of any kind are permitted ;)
Sending new code and ideas to stjordanov@hotmail.com will be appreciated

Author: Demosten - http://demosten.com (stjordanov@hotmail.com)

****************************************************************/

#include <conio.h>
#include <stdio.h>
#include <winsock2.h>
#include <windows.h>
#include "NetAdapterB.h"
#include "PacketCaptureB.h"
#include "ParseFile.h"
#include "Filter.h"

static const char szDefRulesFile[] = "daSniff.rules";
static const char szMutexName[] = "daSniff_win32";
static HANDLE hMutex;
char szErrorString[256]; // keeps error string of all files
static BOOL bWaitOnExit = FALSE; // if true daSniff will wait for pressing a key before exiting

/****************************************************************
PURPOSE: Allows any thread to log an error message
PARAMETERS:
  lpszMsg - text for message
  wType   - event type
****************************************************************/
void AddToMessageLog(LPTSTR lpszMsg, WORD wType)
{
	if (EVENTLOG_ERROR_TYPE == wType)
		fputs(lpszMsg, stderr);
	else
		fputs(lpszMsg, stdout);
}
/****************************************************************
 Quit - exit application (with exit code = iExitCode)
****************************************************************/
void Quit(int iExitCode)
{
	if (bWaitOnExit) {
		fprintf(stdout, "\nPress any key to quit ...\n");
		getch();
	}
	CloseHandle(hMutex);
	exit(iExitCode);
}
/****************************************************************
 ShowUsage - show help info and quits (exit code 1)
****************************************************************/
void ShowUsage(void)
{
static char szUsage[] = "Usage: daSniff [options] <adapter_number> [rules_file_name]\n\n"
"Default rules file name is 'daSniff.rules'\n"
"Default displaying on screen (stdout)\n\n"

"Options:\n"
"   -l : list possible device numbers (do not use # in <adapter_number>)\n"
"   -s : stop on first rule match\n"
"   -d : drop packets containing only header (no data)\n"
"   -w : wait until pressing any key to exit (useful for batch files etc.)\n";

	fprintf(stdout, "%s", szUsage);
	Quit(1);
}
/****************************************************************
 ProcessSwitch() - switch options depending on command line args
****************************************************************/
void ProcessSwitch(char *szSwitch)
{
	switch (szSwitch[1]) {
	case 'h': 
	case '?': ShowUsage(); break;
	case 'd': bDropEmptyPackets = TRUE; break;
	case 's': bStopOnMatch = TRUE; break;
	case 'w': bWaitOnExit = TRUE; break;
	case 'l': ListAdapters(); Quit(3); 
	} // switch
}
/****************************************************************
 cleanup routines
****************************************************************/
void Cleanup(void)
{
	EndCapture();		/* stop capture */
	WSACleanup();		/* stop winsock */
	ParseFileClear();	/* clear rules memory */
	fprintf(stdout, "\nAll packets: %u, Logged: %u\n", 
		dwAllPackets, dwCapturedPackets);
}
/****************************************************************
 CtrlCHandler () intercepts the CTRL+BREAK or CTRL+C events and calls the
 cleanup routines.
****************************************************************/
BOOL __stdcall CtrlCHandler(DWORD dwEvent)
{
	Cleanup();
	fprintf(stdout, "\nInterrupted\n");
	Quit(5);

    return TRUE;
}
/****************************************************************
 startup routines
****************************************************************/
BOOL Startup(void)
{
WSADATA wsadata;

	hMutex = OpenMutex(MUTEX_ALL_ACCESS, FALSE, szMutexName);
	if (NULL != hMutex) {
		fprintf(stdout, "Warning: Another instance of daSniff is already running!\n\n");
		CloseHandle(hMutex);
	}
	else
		hMutex = CreateMutex(NULL, FALSE, szMutexName);

	if (WSAStartup(0x202, &wsadata))	/* init winsock */
		return FALSE;
	
	GetAdapterList();
	
	/* init Ctrl + Break handler */
    if (FALSE == SetConsoleCtrlHandler((PHANDLER_ROUTINE)CtrlCHandler, TRUE))  
		fprintf(stderr, "SetConsoleCtrlHandler() failed: %u\n", GetLastError());
	/* set priority */
	SetPriorityClass(GetCurrentProcess(), HIGH_PRIORITY_CLASS);
	/* init filter */	
	InitFilter();

	return TRUE;
}
/****************************************************************
 main() - Entry point
****************************************************************/
int main(int argc, char **argv)
{
int iCounter, iAdapterIndex = 0, iAdapter;

	fprintf(stdout, "daSniff version 1.41.B - a customizable windows sniffer\n");
	fprintf(stdout, "Author: Demosten - http://demosten.com (stjordanov@hotmail.com)\n\n");

	if (!Startup())
		return 2;

	/* process arguments */
	for (iCounter = 1; iCounter < argc; iCounter++) {
		if (argv[iCounter][0] == '-')
			ProcessSwitch(argv[iCounter]);
		else {
			iAdapterIndex = iCounter;
			break;
		}
	}
	
	/* get adapter */
	if (iAdapterIndex < 1)
		ShowUsage();

	iAdapter = atoi(argv[iAdapterIndex]);
	iAdapterIndex++;
	if (argc > iAdapterIndex) 
		iCounter = StartCapture(iAdapter, argv[iAdapterIndex]);
	else
		iCounter = StartCapture(iAdapter, szDefRulesFile);

	if (0 == iCounter) {
		SetThreadPriority(GetCurrentThread(), THREAD_PRIORITY_LOWEST);
		while (TRUE) Sleep(1000); /* wait forever :) */
	}

	Cleanup();	
	return 0;
}

