/*********************************************************
 HTML 2 PERL - converts HTML page to PERL subroutine

 Autor: Demosten
 http://demosten.com
 email:stjordanov@hotmail.com

 This program is free. You may distribute or modify it as you wish

                                      Enjoy
/*********************************************************/
#include <stdio.h>
#include <string.h>

//#define ESC_PARAMS // Uncomment this if you want parameters "$_[ not to be escaped

#define MAX_BUF		1000

// This is the reserved character with has to be escaped using '\'
char szReservedChars[] = "=@\"'#\\";

// This is the header line it will be added in the beginnig of generated perl file
char szPerlHeader[] = "sub NewSub {\015\012\015\012\
print \"Content-type: text/html\\n\\n\";\015\012\
print \"";

// This is the footer line it will be added in the end of generated perl file
char szPerlFooter[]= "\";\015\012\
}\015\012\
1;";

/*********************************************************/
void ShowHelp(void)
{
	printf("\nSyntax: htm2perl - <input_html_file> <output_perl_file>\n");
}
/*********************************************************/
int ConvertHTML2PERL(char* szHTML, char* szPERL)
{
FILE *fHTML, *fPERL;
int iRead;
int iCounter;
char cBuf[MAX_BUF];


	if ((fHTML = fopen(szHTML, "r")) == NULL) { // open source file
		fprintf(stderr, "Cannot open input file: %s\n", szHTML);
		return 0;
	}
	if ((fPERL = fopen(szPERL, "w")) == NULL) { // open destination file
		fclose(fHTML);
		fprintf(stderr, "Cannot open/create output file: %s\n", szPERL);
		return 0;
	}
	fwrite(szPerlHeader, strlen(szPerlHeader), 1, fPERL); // Write header
	do {
		iRead = fread(cBuf, 1, MAX_BUF, fHTML);
		for (iCounter = 0; iCounter < iRead; iCounter++) {
			if (strchr(szReservedChars, cBuf[iCounter]))
				fputc('\\', fPERL);
			#ifdef ESC_PARAMS
			if (cBuf[iCounter] == '$') {
				if ((cBuf[iCounter+1] == '_') && (cBuf[iCounter+2] == '['));
			    else
					fputc('\\', fPERL);
			}
			#endif
		    fputc(cBuf[iCounter], fPERL);
		}
	} while (!feof(fHTML));
	fwrite(szPerlFooter, strlen(szPerlFooter), 1, fPERL); // Write footer
	fclose(fHTML); // close source file
	fclose(fPERL); // close destinations file
	return 1;
}
/*********************************************************/
void main(int argc, char* argv[])
{
	printf("HTML2PERL - html to perl converter\n\
Copyleft 1999 Demosten - stjordanov@hotmail.com (http://demosten.com)\n");
	if (argc != 3) {
		ShowHelp();
		return;
	}
	if (ConvertHTML2PERL(argv[1], argv[2]))
		printf("\nOk\n");
}
/*********************************************************/

