
/*******************************************************************************

Simple Win32 port scanner
Author: DEM0STEN (http://demosten.com | stjordanov@hotmail.com)
Licence: Freeware

  Please e-mail me bug reports and program improvements in order to keep
  this software updated!

*******************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <windows.h>
#include <winsock.h>

#define E_NO_MORE_PORTS			66000
#define DEFAULT_NUM_THREADS		20
#define MAX_THREADS				300

const char *szLogFileName = "openport.txt";

static HANDLE Handles[MAX_THREADS];

static CRITICAL_SECTION	cs;

struct sSock {
	DWORD dwIP;
	WORD  wPort;
};

static int iThreads;
char szPorts[1000];

DWORD GetNextPort(void);

/******************************************************************************
Display help info :-)
*******************************************************************************/
void Usage(void)
{
	fprintf(stderr, "OpenPort * Simple Win32 port scanner ver. 1.0\n");
	fprintf(stderr, "Warning: scanning is NOT stealth (SYN)!\n");
	fprintf(stderr, "Author: DEM0STEN (http://demosten.com | stjordanov@hotmail.com)\n");
	fprintf(stderr, "usage: <port[..end]> <ip/name[..end]> [num_of_threads (default is %d)]\n\n",
		DEFAULT_NUM_THREADS);

	fprintf(stderr, "Example: openport 2..1023 127.0.0.1..5 5\n");
	fprintf(stderr, "Will scan ports 2 to 1023 on IP 127.0.0.1 to 127.0.0.5 using 5 threads\n");
}
/******************************************************************************
returns the index of the first argument that is not an option; i.e.
does not start with a dash or a slash
*******************************************************************************/
int HandleOptions(int argc,char *argv[])
{
	int i,firstnonoption=0;

	for (i=1; i< argc;i++) {
		if (argv[i][0] == '/' || argv[i][0] == '-') {
			switch (argv[i][1]) {
				/* An argument -? means help is requested */
				case '?':
					Usage();
					break;
				case 'h':
				case 'H':
					if (!stricmp(argv[i]+1,"help")) {
						Usage();
						break;
					}
				/* add your option switches here */
				default:
					fprintf(stderr,"unknown option %s\n",argv[i]);
					break;
			}
		}
		else firstnonoption = i;
	}
	return firstnonoption;
}
/******************************************************************************
Append data to log file
*******************************************************************************/
void AppendToLog(char *szText)
{
FILE *stream;

	stream = fopen(szLogFileName, "at");
	fputs(szText, stream);
	fclose(stream);
}
/*************************************************************************/
DWORD MyThread(struct sSock *pSock)
{
int iResult;
struct sockaddr_in SockAddrIn;
SOCKET MySocket;
char szLine[300];
struct hostent* pHostEnt;

	MySocket = socket(AF_INET, SOCK_STREAM, 0);
	if (MySocket == INVALID_SOCKET) {
		EnterCriticalSection(&cs);
		fprintf(stderr, "invalid socket! Error: %d\n", WSAGetLastError());
		LeaveCriticalSection(&cs);
		free(pSock);
		return 1;
	}

	SockAddrIn.sin_family=AF_INET;
	SockAddrIn.sin_port = htons(pSock->wPort);
	SockAddrIn.sin_addr.s_addr = pSock->dwIP;

	iResult = connect(MySocket, (struct sockaddr *) &SockAddrIn, sizeof(SockAddrIn));
	if (iResult) {
		EnterCriticalSection(&cs);
		fprintf(stderr, "Cannot connect to: %s:%u\n",
			inet_ntoa(SockAddrIn.sin_addr), pSock->wPort);
		LeaveCriticalSection(&cs);
	}
	else {
		pHostEnt = gethostbyaddr((char *)&(pSock->dwIP), 4, PF_INET);
		if (pHostEnt)
			sprintf(szLine, "Connected to: %s:%u (%s)\n",
				inet_ntoa(SockAddrIn.sin_addr), pSock->wPort, pHostEnt->h_name);
		else
			sprintf(szLine, "Connected to: %s:%u\n", inet_ntoa(SockAddrIn.sin_addr), pSock->wPort);

		EnterCriticalSection(&cs);
		AppendToLog(szLine);
		fputs(szLine, stdout);
		LeaveCriticalSection(&cs);
	}
	free(pSock);
	closesocket(MySocket);
	return 0;
}
/*************************************************************************/
DWORD CreateMyThread(DWORD dwIP, WORD wPort)
{
int iCounter;
DWORD dwExitCode, dwThreadID;
struct sSock *pSock = (struct sSock *)malloc(sizeof(struct sSock));
	if (pSock) {
		pSock->dwIP = dwIP;
		pSock->wPort = wPort;
	}
	do {
		for (iCounter = 0; iCounter < iThreads; iCounter++) {
			if (Handles[iCounter] != 0) {
				if (GetExitCodeThread(Handles[iCounter], &dwExitCode)) {
					if (dwExitCode != STILL_ACTIVE)
						Handles[iCounter] = 0;
				}
				else
					Handles[iCounter] = 0;
			}
		}
		for (iCounter = 0; iCounter < iThreads; iCounter++) {
			if (Handles[iCounter] == 0) {
				Handles[iCounter] = CreateThread(0, 0, (LPTHREAD_START_ROUTINE)MyThread, (void *)pSock, 0, &dwThreadID);
				if (Handles[iCounter])
					return dwThreadID;
				else
					fprintf(stderr, "Error creating thread: %u\n", GetLastError());
			}
		}
		Sleep(100);
	} while (TRUE);
	return 0;
}
/*************************************************************************/
void WaitThreads(void)
{
int iCounter;
DWORD dwExitCode;
BOOL bCanExit;

	do {
		bCanExit = TRUE;
		for (iCounter = 0; iCounter < iThreads; iCounter++) {
			if (Handles[iCounter] != 0) {
				if (GetExitCodeThread(Handles[iCounter], &dwExitCode)) {
					if (dwExitCode != STILL_ACTIVE)
						Handles[iCounter] = 0;
				}
				else
					Handles[iCounter] = 0;
			}
			if (Handles[iCounter] != 0)
				bCanExit = FALSE;
		}
		Sleep(100);
	} while (!bCanExit);
}
/******************************************************************************
Begin new log file record
*******************************************************************************/
void LogStartup(void)
{
SYSTEMTIME time;
char szTimeString[300];

	GetLocalTime(&time);
	sprintf(szTimeString, "\n\nNew scanning started on %02u/%02u/%u at %02u:%02u:%02u (dd/mm/YYYY - hh:mm:ss)\n\n",
		time.wDay, time.wMonth, time.wYear, time.wHour, time.wMinute, time.wSecond);
	AppendToLog(szTimeString);
}
/*************************************************************************/
// Connect to port server
BOOL ConnectToServer(char* szServerName, DWORD wEndIPs)
{
int iCounter;
DWORD dwIP;
struct hostent* pHostEnt;
WORD wEndIP;
DWORD dwPort;

	dwIP = inet_addr(szServerName);
	if (dwIP == INADDR_NONE) {
		pHostEnt = gethostbyname(szServerName);
		if (pHostEnt == NULL) {
			fprintf(stderr, "invalid host or ip: %s\n", szServerName);
			return FALSE;
		}
		dwIP = *((unsigned long *)pHostEnt->h_addr);
	}

	LogStartup();

	if ((wEndIPs != 0) && ((dwIP >> 24) < wEndIPs)) {
		wEndIP = (WORD)(wEndIPs - (dwIP >> 24));
		while ((dwPort = GetNextPort()) != E_NO_MORE_PORTS) {
			printf("\nScanning port %u\n\n", dwPort);
			for (iCounter = 0; iCounter <= wEndIP; iCounter++) {
				CreateMyThread(dwIP, (WORD)dwPort);
				dwIP += 0x1000000;
			}
		}
	}
	else {
		while ((dwPort = GetNextPort()) != E_NO_MORE_PORTS)
			CreateMyThread(dwIP, (WORD)dwPort);
	}
	return TRUE;
}
/*************************************************************************/
void Startup(void)
{
int iCounter;
WSADATA wsadata;
	WSAStartup(0x101, &wsadata);
	for (iCounter = 0; iCounter < MAX_THREADS; iCounter++)
		Handles[iCounter] = 0;
	InitializeCriticalSection(&cs);
}
/*************************************************************************/
void Cleanup(void)
{
	WSACleanup();
}
/*************************************************************************/
DWORD GetNextPort(void)
{
static BOOL bEnum;
static DWORD dwCurPort;
static DWORD dwLastPort;
int iCounter, iIndex;
DWORD dwPort;
char cTemp;

	if (strlen(szPorts) == 0)
		return E_NO_MORE_PORTS;

	if (bEnum) {
		if (dwCurPort < dwLastPort)
			dwCurPort++;
		else
			dwCurPort--;
		if (dwCurPort == dwLastPort)
			bEnum = FALSE;
		return dwCurPort;
	}
	for (iCounter = 0; iCounter < (int)strlen(szPorts); iCounter++)
		if ((szPorts[iCounter] == ',') ||
			(szPorts[iCounter] == '-') ||
			(szPorts[iCounter] == 0))
			break;

	switch (szPorts[iCounter]) {
	case ',' : {
		szPorts[iCounter] = 0;
		dwPort = (DWORD)atol(szPorts);
		iIndex = 0;
		do {
			iCounter++;
			szPorts[iIndex] = szPorts[iCounter];
			iIndex++;
		} while (szPorts[iCounter] != 0);
		return dwPort;
	} break;
	case 0 : {
		dwPort = (DWORD)atol(szPorts);
		szPorts[0] = 0;
		return dwPort;
	 	} break;
	case '-': {
		szPorts[iCounter] = 0;
		dwCurPort = (DWORD)atol(szPorts);
		bEnum = TRUE;
		iIndex = 0;
		do {
			iCounter++;
			szPorts[iIndex] = szPorts[iCounter];
			iIndex++;
		} while (szPorts[iCounter] != 0);
		for (iCounter = 0; iCounter < (int)strlen(szPorts); iCounter++)
			if ((szPorts[iCounter] == ',') ||
				(szPorts[iCounter] == '-') ||
				(szPorts[iCounter] == 0))
				break;
		cTemp = szPorts[iCounter];
		szPorts[iCounter] = 0;
		dwLastPort = (DWORD)atol(szPorts);
		iIndex = 0;
		do {
			iCounter++;
			szPorts[iIndex] = szPorts[iCounter];
			iIndex++;
		} while (szPorts[iCounter] != 0);
		return dwCurPort;
	} break;
	} // switch
	return E_NO_MORE_PORTS;
}
/*************************************************************************/
void SplitIP(char *szIPs, char *szStart, DWORD *pdwEnd)
{
char *szSecondIP;
char szIP[300];
	strcpy(szIP, szIPs);
	szSecondIP = strstr(szIP, "..");
	if (szSecondIP) {
		*pdwEnd = atol(&szSecondIP[2]);
		szSecondIP[0] = '\0';
		strcpy(szStart, szIP);
	}
	else {
		strcpy(szStart, szIP);
		*pdwEnd = 0;
	}
}
/*************************************************************************/
int main(int argc,char *argv[])
{
char szServer[300];
DWORD dwEndIP;

	if (argc < 3) {
		Usage();
		return 1;
	}
	/* handle the program options */
	HandleOptions(argc, argv);

	strcpy(szPorts, argv[1]);
	SplitIP(argv[2], szServer, &dwEndIP);

	if (argc == 4) {
		iThreads = atoi(argv[3]);
		if ((iThreads < 1) || (iThreads >= MAX_THREADS)) {
			fprintf(stderr, "Invalid threads number (must be in [1..%d])\n", MAX_THREADS-1);
			return 2;
		}
	}
	else
		iThreads = DEFAULT_NUM_THREADS;

	Startup();
	ConnectToServer(szServer, dwEndIP);
	WaitThreads();
	Cleanup();

	return 0;
}
