/*
Copyright (c) 1999,2003, Demosten (Stanimir Jordanov)
All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
   list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

3. Neither the name of "Demosten" nor the name Stanimir Jordanov may be used to
   endorse or promote products derived from this software without specific prior
   written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
Build notes:
Use lcc-win32 or Visual C++ to build this file into a console application
It should work with other compilers too but I didn't tested it

Don't forget to link with winsock library (wsock32.lib or ws2_32.lib)
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <windows.h>
#include <winsock.h>

#define BUFLEN				1000
#define E_SUCCESS			0
#define E_GENERAL_ERROR		1

const BOOL bTrue = 1;

static CRITICAL_SECTION	cs;
static WORD wLocalPort;			// Store local port number
static FILE *stream;			// file stream for logging
static char szFileName[200];	// keep file name

/******* data types *******************/
typedef struct {
	SOCKET sClient;
} TProxyInfo;

/*****************************************************************/
void ShowUsage(void)
{
	fprintf(stderr, "\n\
HTTP only proxy version 1.1 * Copyright 1999-2003 Demosten\n\
http://demosten.com * e-mail: stjordanov@hotmail.com\n\
Usage: proxy <LocalPort> [LogFile]\n\n");
}
/*****************************************************************/
DWORD GetRemoteIPandPort(char* szInput, WORD *pwPort)
{
DWORD dwIP;
struct hostent* pHostEnt;
char *pHttp, *szPort;
DWORD dwIndex = 0;
char szServerName[BUFLEN];

	if ((pHttp = strstr(szInput, "http://")) == NULL)
		return INADDR_NONE;
	do {
		szServerName[dwIndex] = *(pHttp+dwIndex+7);
		dwIndex++;
	} while ((*(pHttp+dwIndex+7) != 0) && (*(pHttp+dwIndex+7) != '/'));
	szServerName[dwIndex] = 0;
	if ((szPort = strchr(szServerName, ':')) != NULL) {
		*pwPort = (WORD)atoi(szPort+1);
		*szPort = 0;
	}
	else
		*pwPort = 80;

	strcpy(pHttp, pHttp+dwIndex+7);

	if ((pHttp = strstr(szInput, "Proxy-Connection:")) != NULL)
		strcpy(pHttp, pHttp+6);

	dwIP = inet_addr(szServerName);
	if (dwIP == INADDR_NONE) {
		pHostEnt = gethostbyname(szServerName);
		if (pHostEnt == NULL)
			return INADDR_NONE;
		dwIP = *((unsigned long *)pHostEnt->h_addr);
	}
	return dwIP;
}
/*************************************************************************/
DWORD MyProxyThread(TProxyInfo *pInfo)
{
int iResult;
struct sockaddr_in SockAddrIn;
SOCKET MySocket, sClient = pInfo->sClient;
BOOL bClientData = FALSE, bServerData = FALSE;
int iClientLen = 0, iServerLen = 0;
BYTE byClientBuf[BUFLEN], byServerBuf[BUFLEN];
fd_set readfds;
DWORD dwRemoteIP;
WORD wRemotePort;

	// read start info
	memset(byClientBuf, 0, BUFLEN);
	iResult = recv(pInfo->sClient, byClientBuf, BUFLEN, 0);
	if ((iResult == SOCKET_ERROR) || (iResult == 0)) {
		closesocket(pInfo->sClient);
		free(pInfo);
		return 0;
	}
	byClientBuf[iResult] = 0;
	if ((dwRemoteIP = GetRemoteIPandPort(byClientBuf, &wRemotePort)) == INADDR_NONE) {
		closesocket(pInfo->sClient);
		free(pInfo);
		return 0;
	}

	// Create new connection to remote server
	MySocket = socket(AF_INET, SOCK_STREAM, 0);
	if (MySocket == INVALID_SOCKET) {
		closesocket(pInfo->sClient);
		free(pInfo);
		return 1;
	}
	setsockopt(MySocket, SOL_SOCKET, SO_KEEPALIVE, (char *)(&bTrue), sizeof(BOOL));

	SockAddrIn.sin_family=AF_INET;
	SockAddrIn.sin_port = htons(wRemotePort);
	SockAddrIn.sin_addr.s_addr = dwRemoteIP;

	// Connecting remote server
	EnterCriticalSection(&cs);
	fprintf(stderr, "Connecting to: %s:%u   ID:%X\n",
		inet_ntoa(SockAddrIn.sin_addr), wRemotePort, GetCurrentThreadId());
	LeaveCriticalSection(&cs);

	iResult = connect(MySocket, (struct sockaddr *) &SockAddrIn, sizeof(SockAddrIn));
	if (iResult) {
		EnterCriticalSection(&cs);
		fprintf(stderr, "Cannot connect to: %s:%u   ID:%X\n",
			inet_ntoa(SockAddrIn.sin_addr), wRemotePort, GetCurrentThreadId());
		LeaveCriticalSection(&cs);
		closesocket(sClient);
		return 0;
	}

	EnterCriticalSection(&cs);
	printf("Connected to: %s:%u   ID:%X\n",
   		inet_ntoa(SockAddrIn.sin_addr), wRemotePort, GetCurrentThreadId());
	LeaveCriticalSection(&cs);

	// Seng start info
	if ((iResult = send(MySocket, byClientBuf, strlen(byClientBuf), 0)) == SOCKET_ERROR) {
		closesocket(MySocket);
		closesocket(pInfo->sClient);
		free(pInfo);
		return 0;
	}
	if (szFileName[0] != 0) {
		EnterCriticalSection(&cs);
		if ((stream = fopen(szFileName, "a")) != NULL) {
			fputs("\n<-\n", stream);
			fwrite(byClientBuf, 1, strlen(byClientBuf), stream);
			fclose(stream);
		}
		LeaveCriticalSection(&cs);
	}

	do {
		FD_ZERO(&readfds);
		FD_SET(MySocket, &readfds);
		FD_SET(sClient, &readfds);
		iResult = select(0, &readfds, NULL, NULL, NULL);
		if (iResult == SOCKET_ERROR) {
			EnterCriticalSection(&cs);
			fprintf(stderr, "select() error: %u   ID:%X\n",
		   		WSAGetLastError(), GetCurrentThreadId());
			LeaveCriticalSection(&cs);
			break;
		}
		if (iClientLen < BUFLEN) {
			if ((FD_ISSET(sClient, &readfds)) && (!bClientData)) {
				iResult = recv(sClient, &byClientBuf[iClientLen], BUFLEN-iClientLen, 0);
				if (iResult == 0) {
					EnterCriticalSection(&cs);
					fprintf(stderr, "Connection closed   ID:%X\n", GetCurrentThreadId());
					LeaveCriticalSection(&cs);
					break;
				}
		    	if (iResult == SOCKET_ERROR) {
					EnterCriticalSection(&cs);
					fprintf(stderr, "Socket error (client receive): %u   ID:%X\n",
				   		WSAGetLastError(), GetCurrentThreadId());
					LeaveCriticalSection(&cs);
					break;
				}
				bClientData = TRUE;
				iClientLen += iResult;
			}
		}
		if (bClientData) {
			iResult = send(MySocket, byClientBuf, iClientLen, 0);
			if (iResult == SOCKET_ERROR) {
				EnterCriticalSection(&cs);
				fprintf(stderr, "Socket error (send to server): %u   ID:%X\n",
			    	WSAGetLastError(), GetCurrentThreadId());
				LeaveCriticalSection(&cs);
				break;
			}
			if (szFileName[0] != 0) {
				EnterCriticalSection(&cs);
				if ((stream = fopen(szFileName, "a")) != NULL) {
					fputs("\n<-\n", stream);
					fwrite(byClientBuf, 1, iClientLen, stream);
					fclose(stream);
				}
				LeaveCriticalSection(&cs);
			}
			bClientData = FALSE;
			iClientLen = 0;
		}
		if (iServerLen < BUFLEN) {
			if ((FD_ISSET(MySocket, &readfds)) && (!bServerData)) {
				iResult = recv(MySocket, &byServerBuf[iServerLen], BUFLEN-iServerLen, 0);
				if (iResult == 0) {
					EnterCriticalSection(&cs);
					fprintf(stderr, "Connection closed   ID:%X\n", GetCurrentThreadId());
					LeaveCriticalSection(&cs);
					break;
				}
		    	if (iResult == SOCKET_ERROR) {
					EnterCriticalSection(&cs);
					fprintf(stderr, "Socket error (server receive): %u   ID:%X\n",
						WSAGetLastError(), GetCurrentThreadId());
					LeaveCriticalSection(&cs);
					break;
				}
				bServerData = TRUE;
				iServerLen += iResult;
			}
		}
		if (bServerData) {
			iResult = send(sClient, byServerBuf, iServerLen, 0);
			if (iResult == SOCKET_ERROR) {
				EnterCriticalSection(&cs);
				fprintf(stderr, "Socket error (send to client): %u   ID:%X\n",
					WSAGetLastError(), GetCurrentThreadId());
				LeaveCriticalSection(&cs);
				break;
			}
			if (szFileName[0] != '\0') {
				EnterCriticalSection(&cs);
				if ((stream = fopen(szFileName, "a")) != NULL) {
					fputs("\n->\n", stream);
					fwrite(byServerBuf, 1, iServerLen, stream);
					fclose(stream);
				}
				LeaveCriticalSection(&cs);
			}
			bServerData = FALSE;
			iServerLen = 0;
		}
	} while (TRUE);
	closesocket(MySocket);
	closesocket(sClient);
	return 0;
}
/*************************************************************************/
int StartProxy(void)
{
SOCKADDR_IN saServer;
SOCKADDR_IN saRemote;
int iSALen;
int iResult;
SOCKET sListen;			// socket to listen
SOCKET sClient;			// Client socket
DWORD dwThreadID;
TProxyInfo *pInfo;

	// Prepare listen socket
    /* -------- Fill in the address structure for local -------- */
    saServer.sin_family = AF_INET;			// Address family
    saServer.sin_addr.s_addr = INADDR_ANY;	// Let WinSock assign address
    saServer.sin_port = htons(wLocalPort);	// Port number from command line

    /* -------- Create a TCP/IP stream socket to "listen" with -------- */
    sListen = socket( AF_INET, SOCK_STREAM,	IPPROTO_TCP);
    if (sListen == INVALID_SOCKET)
		return E_GENERAL_ERROR;
    /* -------- bind the name to the socket -------- */
    iResult = bind(sListen,	(LPSOCKADDR)&saServer, sizeof(struct sockaddr));
    if (iResult == SOCKET_ERROR) {
		closesocket(sListen);
		return E_GENERAL_ERROR;
	}
    /* -------- Set the socket to listen -------- */
    iResult = listen(sListen, SOMAXCONN);
    if (iResult == SOCKET_ERROR) {
		closesocket(sListen);
		return E_GENERAL_ERROR;
	}

	fprintf(stdout, "HTTP proxy started: redirecting localhost:%u\n", wLocalPort);
	fprintf(stdout, "Press Ctrl+C to end ...\n");

	do {
	    /* -------- Accept connection -------- */
	    iSALen = sizeof(SOCKADDR);
	    sClient = accept(sListen, (SOCKADDR*)&saRemote, &iSALen);
	    if (sClient == SOCKET_ERROR)
			break;
		setsockopt(sClient, SOL_SOCKET, SO_KEEPALIVE, (char *)(&bTrue), sizeof(BOOL));

		if ((pInfo = malloc(sizeof(TProxyInfo))) == NULL)
			return E_GENERAL_ERROR;
		pInfo->sClient = sClient;
		CreateThread(0, 0, &MyProxyThread, (void *)pInfo, 0, &dwThreadID);

	} while (TRUE);
	closesocket(sListen);
	return E_SUCCESS;
}
/*************************************************************************/
void Startup(void)
{
WSADATA wsadata;
	WSAStartup(0x101, &wsadata);
	InitializeCriticalSection(&cs);
}
/*************************************************************************/
void Cleanup(void)
{
	WSACleanup();
	DeleteCriticalSection(&cs);
}
/*****************************************************************/
int main(int argc,char *argv[])
{
	if ((argc < 2) || (argc > 3)){
		ShowUsage();
		return 1;
	}
	// Get LocalPort
	wLocalPort = atoi(argv[1]);
	if (wLocalPort == 0) {
		fprintf(stderr, "local_port cannot be ""0"" or invalid port number\n");
		return 2;
	}
	// Get file name if any
	if (argc == 3)
		strcpy(szFileName, argv[2]);
	else
		szFileName[0] = '\0';

	// Start service
	Startup();
	StartProxy();
	Cleanup();

	// bye success :)
	return 0;
}
/*****************************************************************/

