/*
Copyright (c) 1999,2004, Demosten (Stanimir Jordanov)
All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
   list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

3. Neither the name of "Demosten" nor the name Stanimir Jordanov may be used to
   endorse or promote products derived from this software without specific prior
   written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
Build notes:
Use lcc-win32 or Visual C++ to build this file into a console application
It should work with other compilers too but I didn't tested it

Don't forget to link with winsock library (wsock32.lib or ws2_32.lib)
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <windows.h>
#include <winsock.h>

#define BUFLEN			1000
#define MAX_CONS		256

static CRITICAL_SECTION	cs;
static int iMaxCons; 		// Store maximum allowed connections
static WORD wLocalPort;		// Store local port number
static WORD wRemotePort;	// Store remote port number
static DWORD dwRemoteIP;	// Store remote IP
static FILE *stream;			// file stream for logging
static char szFileName[200];	// keep file name

/*****************************************************************/
void ShowUsage(void)
{
	fprintf(stderr, "\nUsage: redirect <LocalPort> <RemoteServer> <RemotePort> <MaxCons> [LogFile]\n\n\
   Note: Remote server may 'loop' :-)\n\
");
}
/*************************************************************************/
DWORD GetRemoteIP(char* szServerName)
{
DWORD dwIP;
struct hostent* pHostEnt;

	if (!strcmp(szServerName, "loop"))
		return INADDR_NONE+1;
	dwIP = inet_addr(szServerName);
	if (dwIP == INADDR_NONE) {
		pHostEnt = gethostbyname(szServerName);
		if (pHostEnt == NULL) {
			fprintf(stderr, "invalid host or ip: %s\n", szServerName);
			return INADDR_NONE;
		}
		dwIP = *((unsigned long *)pHostEnt->h_addr);
	}
	return dwIP;
}
/*************************************************************************/
DWORD MyThread(SOCKET sClient)
{
int iResult;
struct sockaddr_in SockAddrIn;
SOCKET MySocket;
BOOL bClientData = FALSE, bServerData = FALSE;
int iClientLen = 0, iServerLen = 0;
BYTE byClientBuf[BUFLEN], byServerBuf[BUFLEN];
fd_set readfds;

	// Create new connection to remote server
	MySocket = socket(AF_INET, SOCK_STREAM, 0);
	if (MySocket == INVALID_SOCKET) {
		EnterCriticalSection(&cs);
		fprintf(stderr, "invalid socket! Error: %d   ID:%X\n",
			WSAGetLastError(), GetCurrentThreadId());
		LeaveCriticalSection(&cs);
		closesocket(sClient);
		return 1;
	}

	SockAddrIn.sin_family=AF_INET;
	SockAddrIn.sin_port = htons(wRemotePort);
	SockAddrIn.sin_addr.s_addr = dwRemoteIP;

	// Connecting remote server
	EnterCriticalSection(&cs);
	fprintf(stderr, "Connecting to: %s:%u   ID:%X\n",
		inet_ntoa(SockAddrIn.sin_addr), wRemotePort, GetCurrentThreadId());
	LeaveCriticalSection(&cs);

	iResult = connect(MySocket, (struct sockaddr *) &SockAddrIn, sizeof(SockAddrIn));
	if (iResult) {
		EnterCriticalSection(&cs);
		fprintf(stderr, "Cannot connect to: %s:%u   ID:%X\n",
			inet_ntoa(SockAddrIn.sin_addr), wRemotePort, GetCurrentThreadId());
		LeaveCriticalSection(&cs);
		closesocket(sClient);
		return 0;
	}

	EnterCriticalSection(&cs);
	printf("Connected to: %s:%u   ID:%X\n",
   		inet_ntoa(SockAddrIn.sin_addr), wRemotePort, GetCurrentThreadId());
	LeaveCriticalSection(&cs);

	do {
		FD_ZERO(&readfds);
		FD_SET(MySocket, &readfds);
		FD_SET(sClient, &readfds);
		iResult = select(0, &readfds, NULL, NULL, NULL);
		if (iResult == SOCKET_ERROR) {
			EnterCriticalSection(&cs);
			fprintf(stderr, "select() error: %u   ID:%X\n",
		   		WSAGetLastError(), GetCurrentThreadId());
			LeaveCriticalSection(&cs);
			break;
		}
		if (iClientLen < BUFLEN) {
			if ((FD_ISSET(sClient, &readfds)) && (!bClientData)) {
				iResult = recv(sClient, &byClientBuf[iClientLen], BUFLEN-iClientLen, 0);
				if (iResult == 0) {
					EnterCriticalSection(&cs);
					fprintf(stderr, "Connection closed   ID:%X\n", GetCurrentThreadId());
					LeaveCriticalSection(&cs);
					break;
				}
		    	if (iResult == SOCKET_ERROR) {
					EnterCriticalSection(&cs);
					fprintf(stderr, "Socket error (client receive): %u   ID:%X\n",
				   		WSAGetLastError(), GetCurrentThreadId());
					LeaveCriticalSection(&cs);
					break;
				}
				bClientData = TRUE;
				iClientLen += iResult;
			}
		}
		if (bClientData) {
			iResult = send(MySocket, byClientBuf, iClientLen, 0);
			if (iResult == SOCKET_ERROR) {
				EnterCriticalSection(&cs);
				fprintf(stderr, "Socket error (send to server): %u   ID:%X\n",
			    	WSAGetLastError(), GetCurrentThreadId());
				LeaveCriticalSection(&cs);
				break;
			}
			if (szFileName[0] != '\0') {
				EnterCriticalSection(&cs);
				if ((stream = fopen(szFileName, "a")) != NULL) {
					fputs("\n<-\n", stream);
					fwrite(byClientBuf, 1, iClientLen, stream);
					fclose(stream);
				}
				LeaveCriticalSection(&cs);
			}
			bClientData = FALSE;
			iClientLen = 0;
		}
		if (iServerLen < BUFLEN) {
			if ((FD_ISSET(MySocket, &readfds)) && (!bServerData)) {
				iResult = recv(MySocket, &byServerBuf[iServerLen], BUFLEN-iServerLen, 0);
				if (iResult == 0) {
					EnterCriticalSection(&cs);
					fprintf(stderr, "Connection closed   ID:%X\n", GetCurrentThreadId());
					LeaveCriticalSection(&cs);
					break;
				}
		    	if (iResult == SOCKET_ERROR) {
					EnterCriticalSection(&cs);
					fprintf(stderr, "Socket error (server receive): %u   ID:%X\n",
						WSAGetLastError(), GetCurrentThreadId());
					LeaveCriticalSection(&cs);
					break;
				}
				bServerData = TRUE;
				iServerLen += iResult;
			}
		}
		if (bServerData) {
			iResult = send(sClient, byServerBuf, iServerLen, 0);
			if (iResult == SOCKET_ERROR) {
				EnterCriticalSection(&cs);
				fprintf(stderr, "Socket error (send to client): %u   ID:%X\n",
					WSAGetLastError(), GetCurrentThreadId());
				LeaveCriticalSection(&cs);
				break;
			}
			if (szFileName[0] != '\0') {
				EnterCriticalSection(&cs);
				if ((stream = fopen(szFileName, "a")) != NULL) {
					fputs("\n->\n", stream);
					fwrite(byServerBuf, 1, iServerLen, stream);
					fclose(stream);
				}
				LeaveCriticalSection(&cs);
			}
			bServerData = FALSE;
			iServerLen = 0;
		}
	} while (TRUE);
	closesocket(MySocket);
	closesocket(sClient);
	return 0;
}
/*************************************************************************/
void StartRedirect(WORD wLocalPrt, char* szServerName, WORD wRemotePrt, int iMaxConnections)
{
SOCKADDR_IN saServer;
SOCKADDR_IN saRemote;
int iSALen;
int iResult;
SOCKET sListen;			// socket to listen
SOCKET sClient;			// Client socket
DWORD dwThreadID;

	// Get IP number of the server
	dwRemoteIP = GetRemoteIP(szServerName);
	if (dwRemoteIP == INADDR_NONE)
		return;

	// Prepare listen socket

    /* -------- Fill in the address structure for local -------- */
    saServer.sin_family = AF_INET;			// Address family
    saServer.sin_addr.s_addr = INADDR_ANY;	// Let WinSock assign address
    saServer.sin_port = htons(wLocalPrt);	// Port number from command line

    /* -------- Create a TCP/IP stream socket to "listen" with -------- */
    sListen = socket( AF_INET, SOCK_STREAM,	IPPROTO_TCP);
    if (sListen == INVALID_SOCKET) {
		fprintf(stderr, "Cannot create listen socket\n");
		return;
	}
    /* -------- bind the name to the socket -------- */
    iResult = bind(sListen,	(LPSOCKADDR)&saServer, sizeof(struct sockaddr));
    if (iResult == SOCKET_ERROR) {
		closesocket(sListen);
		fprintf(stderr, "Cannot bind listen socket\n");
		return;
	}
    /* -------- Set the socket to listen -------- */
    iResult = listen(sListen, iMaxConnections);
    if (iResult == SOCKET_ERROR) {
		closesocket(sListen);
		return;
	}

	printf("Service started: redirecting localhost:%u to %s:%u\n", wLocalPrt, szServerName, wRemotePrt);
	printf("Press Ctrl+C to end ...\n");

	do {
	    /* -------- Accept connection -------- */
	    iSALen = sizeof(SOCKADDR);
	    sClient = accept(sListen, (SOCKADDR*)&saRemote, &iSALen);
	    if (sClient == SOCKET_ERROR) {
			fprintf(stderr, "Cannot accept connection. Socket error: %u\n", WSAGetLastError());
			break;
		}
		if (!strcmp(szServerName, "loop"))
			dwRemoteIP = saRemote.sin_addr.S_un.S_addr;
		EnterCriticalSection(&cs);
		CreateThread(0, 0, &MyThread, (void *)sClient, 0, &dwThreadID);
		printf("Request accepted, client: %s:%d ID:%X\n", inet_ntoa(saRemote.sin_addr),
			ntohs(saRemote.sin_port), dwThreadID);
		LeaveCriticalSection(&cs);
	} while (TRUE);
	closesocket(sListen);
}
/*************************************************************************/
void Startup(void)
{
WSADATA wsadata;
	WSAStartup(0x101, &wsadata);
	InitializeCriticalSection(&cs);
}
/*************************************************************************/
void Cleanup(void)
{
	WSACleanup();
}
/*****************************************************************/
int main(int argc,char *argv[])
{
	fprintf(stderr, "\nTCP connection redirect v1.1 freeware\nCopyright (c) 1999-2004, Demosten (Stanimir Jordanov)\nhttp://demosten.com or stjordanov@hotmail.com");
	if ((argc < 5) || (argc > 6)){
		ShowUsage();
		return 1;
	}
	// Get LocalPort
	wLocalPort = atoi(argv[1]);
	if (wLocalPort == 0) {
		fprintf(stderr, "local_port cannot be ""0"" or invalid port number\n");
		return 2;
	}
	// Get remote port
	wRemotePort = atoi(argv[3]);
	if (wRemotePort == 0) {
		fprintf(stderr, "remote_port cannot be ""0"" or invalid port number\n");
		return 3;
	}
	// Get max allowed connections
	iMaxCons = atoi(argv[4]);
	if ((iMaxCons == 0) || (iMaxCons > MAX_CONS)) {
		fprintf(stderr, "max_allowed_connections cannot be ""0"" or bigger than %u\n", MAX_CONS);
		return 4;
	}
	// Get file name if any
	if (argc == 6)
		strcpy(szFileName, argv[5]);
	else
		szFileName[0] = '\0';

	// Start service
	Startup();
	StartRedirect(wLocalPort, argv[2], wRemotePort, iMaxCons);
	Cleanup();

	// bye success :)
	return 0;
}
