
#!/usr/bin/perl

################################################################################
# Visual basic form to Perl converter
# Author: Demosten http://demosten.com/ or stjordanov@hotmail.com
# Based on frm2pl.pl from Win32::GUI samples by Aldo Calpini <dada@perl.it>
# version 1.0 from 26.VII.2001
# Created using ActiveState Perl 5.6.1   
#
# This program is free software; you can redistribute it and/or
# modify it under the same terms as Perl itself.
################################################################################
# ToDo:
# add all event handlers ?
# add scroll bars ?
# get some program options to the nice command line interface
# make this GUI ;)
################################################################################

#use warnings;
use strict;

# OPTIONS
our $write_events = 1; # 0 = do not write events
our $hide_perl_window = 0; # set to 1 to generate code to hide perl console window

# clobal variables
our %properties = (   # name                  perl value
                      CAPTION             => 'title',
                      CLIENTHEIGHT        => 'height',
                      CLIENTWIDTH         => 'width',
                      CLIENTLEFT          => 'left',
                      CLIENTTOP           => 'top',
                      HEIGHT              => 'height',
                      WIDTH               => 'width',
                      LEFT                => 'left',
                      TOP                 => 'top',
                      TABINDEX            => 'tabstop',
                      CHECKED             => 'checked'
                  );
our $FormName = '';
our $doing = ''; # what type of operation we are in (form, menu .. etc.)
our $eventscode = "# Event handlers ##########\n\n"; # events code
our $maincode = ''; # common code
our $windowcode = ''; # dialog create and show
our $menucode = ''; # menu code
 
  print "# Visual basic form to Perl converter by Demosten v1.0\n# http://demosten.com/ or stjordanov\@hotmail.com\n\n";
#  my $srcfile = 'E:/private/Source/Perl/vbf2pl/Form1.frm';
  my $srcfile = shift;
  if (!$srcfile) {
    Usage();
    exit 1;
  }
  
#  my $destfile = 'E:/private/Source/Perl/vbf2pl/Form1.pl';
  my $destfile = shift;

  vbf2pl($srcfile, $destfile);
  
  exit 0;

################################################################################
# Main routine 
################################################################################
sub vbf2pl {
  my ($src, $dest, $twips) = @_;
  my $line;
  my $menudepth = 0;
  my ($menuname, $menuchecked, $menucaption);
  $twips = 15 unless $twips; 

  open FRM, $src or die "# Cannot open file $src for reading\n";
  if ($dest) {
    open DEST, ">$dest" or die "# Cannot open file $dest for writing\n";
  }
  else { *DEST = *STDOUT }

  # print standard header
  $menucode .= "\nuse Win32::GUI;\n\n";
  if ($hide_perl_window) {
    $menucode .= "my (\$PerlWindow) = Win32::GUI::GetPerlWindow();\nWin32::GUI::Hide(\$PerlWindow);\n\n";
  }
  
  while ($line = <FRM>) {
    chomp $line;
    $line =~ s/^\s*//; # remove spaces at start
    $line =~ s/\s*$//; # remove spaces at end
    my ($command, $what, $name) = split(/\s+/, $line, 3);
    $command = uc $command;
    $what = uc $what;
    if ($name =~ /^\d+\s+'/) {
      # remove comments after numbers 
      # (perl does it anyway stoping on first non number but this looks nice) :)
      $name =~ s/\s+'.*//; 
    }
    if ($command =~ /^BEGIN$/) {
      # init
      if ($menudepth > 0) {
        if ($menuname && $menucaption) {
          $menucode .= "\t\"$menucaption\" => { -name => \"$menuname\", -checked => $menuchecked },\n";
          $menuname = '';
        }
      }
      elsif ($doing) {
        $maincode .= ");\n\n";
        $doing = '';
      }
      # checks start
      if ($what =~ /^VB\.FORM$/) {
        $FormName = $name;
        $maincode .= "\$$FormName = new Win32::GUI::Window(\n";
        $maincode .= "\t-menu => \$Menu,\n";
        $maincode .= "\t-name => \"$name\",\n";
        $windowcode .= "\n\$$FormName->Show();\nWin32::GUI::Dialog();\n\n";
        AddWindowEvents($name);
        $doing = 'form';
      } elsif($what =~ /^VB\.COMMANDBUTTON$/) {
          $maincode .= GetCtrl('Button', $name);
          AddButtonEvents($name);
      } elsif($what =~ /^VB\.TEXTBOX$/) {
          $maincode .= GetCtrl('Textfield', $name);
          AddTextfieldEvents($name);
      } elsif($what =~ /^VB\.CHECKBOX$/) {
          $maincode .= GetCtrl('Checkbox', $name);
          AddButtonEvents($name);
      } elsif($what =~ /^VB\.LABEL$/) {
          $maincode .= GetCtrl('Label', $name);
          AddLabelEvents($name);
      } elsif($what =~ /^VB\.LISTBOX$/) {
          $maincode .= GetCtrl('Listbox', $name);
          AddButtonEvents($name); # have same events
      } elsif($what =~ /^VB\.OPTIONBUTTON$/) {
          $maincode .= GetCtrl('RadioButton', $name);
          AddButtonEvents($name);
      } elsif($what =~ /^VB\.FRAME$/) {
          $maincode .= GetCtrl('Groupbox', $name);
      } elsif($what =~ /^VB\.COMBOBOX$/) {
          $maincode .= GetCtrl('Combobox', $name);
          AddComboboxEvents($name);
      } elsif($what =~ /^MSCOMCTLLIB\.TREEVIEW$/) {
          $maincode .= GetCtrl('TreeView', $name);
          AddTreeViewEvents($name);
      } elsif($what =~ /^MSCOMCTLLIB\.IMAGELIST$/) {
          $maincode .= GetCtrl('ImageList', $name);
      } elsif($what =~ /^MSCOMCTLLIB\.STATUSBAR$/) {
          $maincode .= GetCtrl('StatusBar', $name);
      } elsif($what =~ /^MSCOMCTLLIB\.PROGRESSBAR$/) {
          $maincode .= GetCtrl('ProgressBar', $name);
      } elsif($what =~ /^MSCOMCTLLIB\.LISTVIEW$/) {
          $maincode .= GetCtrl('ListView', $name);
          $maincode .= "\t-style => WS_CHILD | WS_VISIBLE | 2,\n";
          AddListViewEvents($name);
      } elsif($what =~ /^MSCOMCTLLIB\.SLIDER$/) {
          $maincode .= GetCtrl('Slider', $name);
          AddSliderEvents($name);
      } elsif($what =~ /^MSCOMCTLLIB\.TOOLBAR$/) {
          $maincode .= GetCtrl('Toolbar', $name);
          AddToolbarEvents($name);
      } elsif($what =~ /^MSCOMCTLLIB\.TABSTRIP$/) {
          $maincode .= GetCtrl('TabStrip', $name);
          AddTabStripEvents($name);
      } elsif($what =~ /^VB\.MENU$/) {
          $menuname = $name;
          $menuchecked = 0;
          $menucaption = '';          
          if ($menudepth == 0) { $menucode .= "\$Menu = Win32::GUI::MakeMenu(\n"; }
          $menudepth++;
          $doing = 'menu';
#          AddMenuEvents($name);
      }          
    }
    elsif ($command =~ /^CAPTION$/i && $doing) {
      if ($menudepth == 0) { 
        $maincode .= "\t-title => $name,\n";
      }
      else {
        $menucaption = '';
        for (my $counter = 0; $counter < $menudepth-1; $counter++) { $menucaption .= '>'; }
        $menucaption .= RemoveQuotes($name);          
      }
    }
    elsif ($command =~ /^CLIENTHEIGHT$/ && $doing) {
      $maincode .= SetNumberProperty($command, $name, $twips);
    }
    elsif ($command =~ /^CLIENTWIDTH$/ && $doing) {
      $maincode .= SetNumberProperty($command, $name, $twips);
    }
    elsif ($command =~ /^CLIENTTOP$/ && $doing) {
      $maincode .= SetNumberProperty($command, $name, $twips);
    }
    elsif ($command =~ /^CLIENTLEFT$/ && $doing) {
      $maincode .= SetNumberProperty($command, $name, $twips);
    }
    elsif ($command =~ /^HEIGHT$/ && $doing) {
      $maincode .= SetNumberProperty($command, $name, $twips);
    }
    elsif ($command =~ /^WIDTH$/ && $doing) {
      $maincode .= SetNumberProperty($command, $name, $twips);
    }
    elsif ($command =~ /^TOP$/ && $doing) {
      $maincode .= SetNumberProperty($command, $name, $twips);
    }
    elsif ($command =~ /^LEFT$/ && $doing) {
      $maincode .= SetNumberProperty($command, $name, $twips);
    }
    elsif ($command =~ /^TABINDEX$/ && $doing) {
      $maincode .= SetNumberProperty($command, $name, 1);
    }
    elsif ($command =~ /^CHECKED$/ && $doing) {
      $menuchecked = abs $name;
    }
    elsif ($command =~ /^STYLE$/ && ($doing eq 'Combobox')) {
      $name++; # don't ask why (just made it work)
      $maincode .= "\t-style => WS_VISIBLE | WS_NOTIFY | $name,\n";
    }
    elsif ($command =~ /^END$/ && $doing) {
      if ($menudepth > 0) {
        $menudepth--;
        if ($menuname && $menucaption) { # print last menu item
          $menucode .= "\t\"$menucaption\" => { -name => \"$menuname\", -checked => $menuchecked },\n";
          $menuname = '';
        }
        if ($menudepth == 0) {
          $menucode .= ");\n\n";
          $doing = '';
        }
      }
      elsif ($doing) { 
        $maincode .= ");\n\n"; 
        $doing = '';
      }
    }            
  } # while

  if ($hide_perl_window) {
    $windowcode .= "Win32::GUI::Show(\$PerlWindow);\n\n";
  }

  print DEST $menucode;
  print DEST $maincode;
  print DEST $windowcode;
  if ($write_events) {
    print DEST $eventscode;
  }
  
  close DEST;
  close FRM;

}
################################################################################
# Set property as a number converting twips to pixels
# return result as string
################################################################################
sub SetNumberProperty {
  my ($property, $number, $twips) = @_;
  $twips = 15 unless $twips; 
  my $num = $number / $twips; # convert twips number to pixels
  $property = $properties{$property};
  if ($property) {
    return "\t-$property => $num,\n";
  }
  return '';  
}
################################################################################
# Add a control by name
# return result as string
################################################################################
sub GetCtrl {
  return '' unless $FormName;
  my ($ctrl, $name) = @_;
  $doing = $ctrl;
  return "\$$name = \$$FormName->Add$ctrl(\n\t-name => \"$name\",\n";
}
################################################################################
sub Usage {
  print "# Usage vbf2pl <source_file> [destination_file]\n"; 
  print "# Notes:\n";
  print "#   1. <source_file> is a Visual Basic .FRM file\n";
  print "#   2. if destination_file is not set, STDOUT is used\n";
}
################################################################################
sub AddWindowEvents {
  my $name = shift;
  $eventscode .= "\nsub ${name}_Terminate {\n\t#Sent when the window is closed. The event should return -1\n\t#to terminate the interaction and return control to the perl script\n\treturn -1;\n}\n\n";
  $eventscode .= "sub ${name}_Resize {\n\t#Sent when the window is resized.\n}\n\n"; 
#  $eventscode .= "sub ${name}_Minimize {\n\t#ToDo: add minimize code here\n}\n\n"; 
#  $eventscode .= "sub ${name}_Maximize {\n\t#ToDo: add maximize code here\n}\n\n"; 
  $eventscode .= "sub ${name}_Activate {\n\t#Sent when the window is activated.\n}\n\n"; 
  $eventscode .= "sub ${name}_Deactivate {\n\t#Sent when the window is deactivated.\n}\n\n"; 
}
################################################################################
#sub AddMenuEvents {
#  my $name = shift;
#  $eventscode .= "sub ${name}_Click {\n\t#ToDo: add click code here\n}\n\n"; 
#}
################################################################################
sub AddButtonEvents {
  my $name = shift;
  $eventscode .= "sub ${name}_Click {\n\t#Sent when the user clicks the left mouse button on the button.\n}\n\n"; 
  $eventscode .= "sub ${name}_DblClick {\n\t#ToDo: add double click code here\n}\n\n"; 
  $eventscode .= "sub ${name}_GotFocus {\n\t#ToDo: add on_focus code here\n}\n\n"; 
  $eventscode .= "sub ${name}_LostFocus {\n\t#Occurs when he button is deactivated\n}\n\n"; 
}
################################################################################
sub AddTextfieldEvents {
  my $name = shift;
  $eventscode .= "sub ${name}_Change {\n\t#Sent when the text changes.\n}\n\n"; 
  $eventscode .= "sub ${name}_GotFocus {\n\t#ToDo: add on_focus code here\n}\n\n"; 
  $eventscode .= "sub ${name}_LostFocus {\n\t#Occurs when the textfield is deactivated\n}\n\n"; 
}
################################################################################
sub AddLabelEvents {
  my $name = shift;
  $eventscode .= "sub ${name}_Click {\n\t#Sent when the user clicks the left mouse button on the label.\n}\n\n"; 
  $eventscode .= "sub ${name}_DblClick {\n\t#ToDo: add double click code here\n}\n\n"; 
}
################################################################################
sub AddComboboxEvents {
  my $name = shift;
  $eventscode .= "sub ${name}_Change {\n\t#Sent when the combobox changes.\n}\n\n"; 
  $eventscode .= "sub ${name}_GotFocus {\n\t#ToDo: add on_focus code here\n}\n\n"; 
  $eventscode .= "sub ${name}_LostFocus {\n\t#Occurs when the combobox is deactivated\n}\n\n"; 
}
################################################################################
sub AddSliderEvents {
  my $name = shift;
  $eventscode .= "sub ${name}_Scroll {\n\t#Sent when the user moves an arrow in the slider.\n}\n\n"; 
}
################################################################################
sub AddToolbarEvents {
  my $name = shift;
  $eventscode .= "sub ${name}_ButtonClick {\n\t#Sent when the user presses a button of the Toolbar\n\t#the INDEX argument identifies the zero-based index of the pressed button\n}\n\n"; 
}
################################################################################
sub AddTabStripEvents {
  my $name = shift;
  $eventscode .= "sub ${name}_Change {\n\t#Sent when the TabStrip changes.\n}\n\n"; 
  $eventscode .= "sub ${name}_Changing {\n\t#Sent before the current selection changes. Use SelectedItem() to determine the current selection.\n\t#The event should return 0 to prevent the selection changing, 1 to allow it.\n}\n\n"; 
}
################################################################################
sub AddTreeViewEvents {
  my $name = shift;
  $eventscode .= "sub ${name}_Collapse {\n\t#Sent when the user closes the specified NODE of the TreeView.\n}\n\n"; 
  $eventscode .= "sub ${name}_Collapsing {\n\t#Sent when the user is about to close the specified NODE of the TreeView.\n\t#The event should return 0 to prevent the action, 1 to allow it.\n}\n\n"; 
  $eventscode .= "sub ${name}_Expand {\n\t#Sent when the user opens the specified NODE of the TreeView.\n}\n\n"; 
  $eventscode .= "sub ${name}_Expanding {\n\t#Sent when the user is about to open the specified NODE of the TreeView.\n\t#The event should return 0 to prevent the action, 1 to allow it.\n}\n\n"; 
  $eventscode .= "sub ${name}_KeyDown {\n\t#Sent when the user presses a key while the TreeView has focus;\n\t#KEY is the ASCII code of the key being pressed.\n}\n\n"; 
  $eventscode .= "sub ${name}_NodeClick {\n\t#Sent when the user clicks on the specified NODE of the TreeView.\n}\n\n"; 
}
################################################################################
sub AddListViewEvents {
  my $name = shift;
  $eventscode .= "sub ${name}_ColumnClick {\n\t#Sent when the user clicks on a column header in the ListView;\n\t#ITEM specifies the one-based index of the selected column.\n}\n\n"; 
  $eventscode .= "sub ${name}_ItemClick {\n\t#Sent when the user selects an item in the ListView;\n\t#ITEM specifies the zero-based index of the selected item.\n}\n\n"; 
  $eventscode .= "sub ${name}_KeyDown {\n\t#Sent when the user presses a key while the Object (control) has focus;\n\t#KEY is the ASCII code of the key being pressed.\n}\n\n"; 
}
################################################################################
sub RemoveQuotes {
  my $result = shift;
  $result =~ s/^"//; # remove start quotes 
  $result =~ s/"$//; # remove end quotes
  return $result; 
}
################################################################################

